/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.proxy;

import com.robrit.moofluids.common.MooFluids;
import com.robrit.moofluids.common.entity.EntityFluidCow;
import com.robrit.moofluids.common.entity.event.EntityChristmasCow;
import com.robrit.moofluids.common.entity.event.EntityNewYearsCow;
import com.robrit.moofluids.common.event.ConfigurationHandler;
import com.robrit.moofluids.common.event.EntitySpawnHandler;
import com.robrit.moofluids.common.plugins.thaumcraft.ThaumcraftPlugin;
import com.robrit.moofluids.common.plugins.waila.WailaPlugin;
import com.robrit.moofluids.common.proxy.IProxy;
import com.robrit.moofluids.common.ref.ConfigurationData;
import com.robrit.moofluids.common.util.DateHelper;
import com.robrit.moofluids.common.util.EntityHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;

public abstract class CommonProxy
implements IProxy {
    @Override
    public void initContainableFluids() {
        for (FluidContainerRegistry.FluidContainerData fluidContainerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            String fluidName;
            if (fluidContainerData.filledContainer.func_77973_b() == null || EntityHelper.hasContainableFluid(fluidName = fluidContainerData.fluid.getFluid().getName())) continue;
            Fluid containableFluid = fluidContainerData.fluid.getFluid();
            EntityHelper.setContainableFluid(fluidName, containableFluid);
        }
    }

    @Override
    public void registerEventHandlers() {
        FMLCommonHandler.instance().bus().register((Object)new ConfigurationHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawnHandler());
    }

    @Override
    public void registerEntities() {
        EntityRegistry.registerGlobalEntityID(EntityFluidCow.class, (String)"EntityFluidCow", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)0xFFFFFF, (int)0xFFFFFF);
        EntityRegistry.registerModEntity(EntityFluidCow.class, (String)"EntityFluidCow", (int)EntityHelper.getRegisteredEntityId(), (Object)MooFluids.getInstance(), (int)64, (int)1, (boolean)true);
        for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.values()) {
            EntityRegistry.addSpawn(EntityFluidCow.class, (int)ConfigurationData.GLOBAL_FLUID_COW_SPAWN_RATE_VALUE, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType));
        }
        if (ConfigurationData.EVENT_ENTITIES_ENABLED_VALUE) {
            if (DateHelper.isDateBetweenEpochBoundaries(1418688000L, 1419724800L)) {
                EntityRegistry.registerGlobalEntityID(EntityChristmasCow.class, (String)"EntityChristmasCow", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)0x228B22, (int)11404549);
                EntityRegistry.registerModEntity(EntityChristmasCow.class, (String)"EntityChristmasCow", (int)EntityHelper.getRegisteredEntityId(), (Object)MooFluids.getInstance(), (int)64, (int)1, (boolean)true);
                EntityRegistry.addSpawn(EntityChristmasCow.class, (int)8, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.COLD));
                EntityRegistry.addSpawn(EntityChristmasCow.class, (int)8, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                EntityRegistry.addSpawn(EntityChristmasCow.class, (int)8, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            }
            if (DateHelper.isDateBetweenEpochBoundaries(1419811200L, 1420156800L)) {
                EntityRegistry.registerGlobalEntityID(EntityNewYearsCow.class, (String)"EntityNewYearsCow", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)0xC0C0C0, (int)16766720);
                EntityRegistry.registerModEntity(EntityNewYearsCow.class, (String)"EntityNewYearsCow", (int)EntityHelper.getRegisteredEntityId(), (Object)MooFluids.getInstance(), (int)64, (int)1, (boolean)true);
                EntityRegistry.addSpawn(EntityNewYearsCow.class, (int)8, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.LUSH));
                EntityRegistry.addSpawn(EntityNewYearsCow.class, (int)8, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL));
                EntityRegistry.addSpawn(EntityNewYearsCow.class, (int)8, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
                EntityRegistry.addSpawn(EntityNewYearsCow.class, (int)8, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            }
        }
    }

    @Override
    public void registerPlugins() {
        if (Loader.isModLoaded((String)"Waila")) {
            WailaPlugin.init();
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            ThaumcraftPlugin.init();
        }
    }
}

