/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics;

import cofh.api.core.IInitializer;
import cofh.core.CoFHProps;
import cofh.core.util.ConfigHandler;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cofh.thermaldynamics.core.Proxy;
import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.debughelper.CommandThermalDebug;
import cofh.thermaldynamics.debughelper.DebugHelper;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.gui.GuiHandler;
import cofh.thermaldynamics.gui.TDCreativeTab;
import cofh.thermaldynamics.item.ItemCover;
import cofh.thermaldynamics.item.ItemFilter;
import cofh.thermaldynamics.item.ItemRetriever;
import cofh.thermaldynamics.item.ItemServo;
import cofh.thermaldynamics.util.crafting.RecipeCover;
import cofh.thermaldynamics.util.crafting.TDCrafting;
import cofh.thermalfoundation.plugins.TFPlugins;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ThermalDynamics", name="Thermal Dynamics", version="1.7.10R1.0.0", dependencies="required-after:ThermalFoundation@[1.7.10R1.0.0,)", guiFactory="cofh.thermaldynamics.gui.GuiConfigTDFactory", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class ThermalDynamics
extends BaseMod {
    public static final String modId = "ThermalDynamics";
    public static final String modName = "Thermal Dynamics";
    public static final String version = "1.7.10R1.0.0";
    public static final String dependencies = "required-after:ThermalFoundation@[1.7.10R1.0.0,)";
    public static final String releaseURL = "https://raw.github.com/CoFH/VERSION/master/ThermalDynamics";
    public static final String modGuiFactory = "cofh.thermaldynamics.gui.GuiConfigTDFactory";
    @Mod.Instance(value="ThermalDynamics")
    public static ThermalDynamics instance;
    @SidedProxy(clientSide="cofh.thermaldynamics.core.ProxyClient", serverSide="cofh.thermaldynamics.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final GuiHandler guiHandler;
    public static CreativeTabs tab;
    LinkedList<IInitializer> initializerList = new LinkedList();
    public static BlockDuct[] blockDuct;
    public static ItemServo itemServo;
    public static ItemFilter itemFilter;
    public static ItemCover itemCover;
    public static ItemRetriever itemRetriever;

    public ThermalDynamics() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL, "http://teamcofh.com/downloads/"));
        proxy.registerPacketInformation();
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/thermaldynamics/common.cfg"), true));
        tab = new TDCreativeTab();
        RecipeSorter.register((String)"thermaldynamics:cover", RecipeCover.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"after:forge:shapedore");
        TDDucts.addDucts();
        int n = (int)Math.ceil((double)TDDucts.ductList.size() / 16.0);
        blockDuct = new BlockDuct[n];
        for (int i = 0; i < n; ++i) {
            ThermalDynamics.blockDuct[i] = this.addBlock(new BlockDuct(i));
        }
        itemServo = this.addItem(new ItemServo());
        itemFilter = this.addItem(new ItemFilter());
        itemCover = this.addItem(new ItemCover());
        itemRetriever = this.addItem(new ItemRetriever());
        for (IInitializer iInitializer : this.initializerList) {
            iInitializer.preInit();
        }
        config.removeCategory("Recipes");
        config.save();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        for (IInitializer iInitializer : this.initializerList) {
            iInitializer.initialize();
        }
        FMLCommonHandler.instance().bus().register((Object)TickHandler.INSTANCE);
        DebugHelper.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        for (IInitializer iInitializer : this.initializerList) {
            iInitializer.postInit();
        }
        proxy.registerRenderInformation();
        TDCrafting.loadRecipes();
        config.cleanUp(false, true);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        TFPlugins.loadComplete();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent fMLServerStartingEvent) {
        if (DebugHelper.debug) {
            fMLServerStartingEvent.registerServerCommand((ICommand)new CommandThermalDebug());
        }
    }

    public <T extends Block> T addBlock(T t) {
        this.initializerList.add((IInitializer)t);
        return t;
    }

    public <T extends Item> T addItem(T t) {
        this.initializerList.add((IInitializer)t);
        return t;
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    @Mod.EventHandler
    public void checkMappings(FMLMissingMappingsEvent fMLMissingMappingsEvent) {
        for (FMLMissingMappingsEvent.MissingMapping missingMapping : fMLMissingMappingsEvent.get()) {
            if (!"ThermalDynamics:TestDuct".equals(missingMapping.name)) continue;
            if (missingMapping.type == GameRegistry.Type.BLOCK) {
                missingMapping.remap((Block)blockDuct[0]);
                continue;
            }
            missingMapping.remap(Item.func_150898_a((Block)blockDuct[0]));
        }
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        guiHandler = new GuiHandler();
    }
}

