/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import tuhljin.automagy.gui.GUIVisReader;
import tuhljin.automagy.gui.SlotRestricted;
import tuhljin.automagy.tiles.TileEntityVisReader;

public class ContainerVisReader
extends Container {
    private static final int numConfigurations = 4;
    private TileEntityVisReader teVR;
    public GUIVisReader attachedGUI = null;
    private int[] oldModes = new int[4];
    private int[] oldCapacities = new int[4];
    private int[] oldOutputDirs = new int[4];
    private boolean[] oldInverseSignals = new boolean[4];

    public ContainerVisReader(InventoryPlayer inventoryPlayer, TileEntityVisReader te) {
        int i;
        this.teVR = te;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotRestricted((IInventory)this.teVR, i, 6, 10 + i * 19));
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 154));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, 9 + j + i * 9, 8 + j * 18, 96 + i * 18));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.teVR.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot instanceof SlotRestricted) {
                if (!this.func_75135_a(stackInSlot, 4, 40, true)) {
                    return null;
                }
            } else {
                if (!this.teVR.func_94041_b(0, stackInSlot)) {
                    return null;
                }
                if (!this.mergeSingleItemFromStack(stackInSlot, 0, 4, false)) {
                    return null;
                }
            }
            if (stackInSlot.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return stack;
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        int i = 0;
        while (true) {
            if (i >= 4) break;
            player.func_71112_a((Container)this, i, this.teVR.modes[i]);
            player.func_71112_a((Container)this, i + 10, this.teVR.capacities[i]);
            player.func_71112_a((Container)this, i + 20, this.teVR.outputDirs[i]);
            player.func_71112_a((Container)this, i + 30, this.teVR.inverseSignals[i] ? 1 : 0);
            ++i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id >= 30) {
            boolean bl = this.teVR.inverseSignals[id -= 30] = data == 1;
            if (this.attachedGUI != null) {
                this.attachedGUI.updateButton(id * 4 + 3, data);
            }
        } else if (id >= 20) {
            this.teVR.outputDirs[id -= 20] = data;
            if (this.attachedGUI != null) {
                this.attachedGUI.updateButton(id * 4 + 2, data);
            }
        } else if (id >= 10) {
            this.teVR.capacities[id -= 10] = data;
            if (this.attachedGUI != null) {
                this.attachedGUI.updateButton(id * 4 + 1, data);
            }
        } else {
            this.teVR.modes[id] = data;
            if (this.attachedGUI != null) {
                this.attachedGUI.updateButton(id * 4, data);
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (Object player : this.field_75149_d) {
            for (int i = 0; i < 4; ++i) {
                if (this.teVR.modes[i] != this.oldModes[i]) {
                    ((ICrafting)player).func_71112_a((Container)this, i, this.teVR.modes[i]);
                }
                if (this.teVR.capacities[i] != this.oldCapacities[i]) {
                    ((ICrafting)player).func_71112_a((Container)this, i + 10, this.teVR.capacities[i]);
                }
                if (this.teVR.outputDirs[i] != this.oldOutputDirs[i]) {
                    ((ICrafting)player).func_71112_a((Container)this, i + 20, this.teVR.outputDirs[i]);
                }
                if (this.teVR.inverseSignals[i] == this.oldInverseSignals[i]) continue;
                ((ICrafting)player).func_71112_a((Container)this, i + 30, this.teVR.inverseSignals[i] ? 1 : 0);
            }
        }
        this.oldModes = Arrays.copyOf(this.teVR.modes, this.teVR.modes.length);
        this.oldCapacities = Arrays.copyOf(this.teVR.capacities, this.teVR.capacities.length);
        this.oldOutputDirs = Arrays.copyOf(this.teVR.outputDirs, this.teVR.outputDirs.length);
        this.oldInverseSignals = Arrays.copyOf(this.teVR.inverseSignals, this.teVR.inverseSignals.length);
    }

    public TileEntityVisReader getTileEntity() {
        return this.teVR;
    }

    protected boolean mergeSingleItemFromStack(ItemStack stack, int firstSlot, int numSlots, boolean reverse) {
        boolean flag1 = false;
        int k = firstSlot;
        if (reverse) {
            k = numSlots - 1;
        }
        if (stack.field_77994_a > 0) {
            k = reverse ? numSlots - 1 : firstSlot;
            while (!reverse && k < numSlots || reverse && k >= firstSlot) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack itemstack1 = slot.func_75211_c();
                if (itemstack1 == null) {
                    ItemStack newStack = stack.func_77946_l();
                    newStack.field_77994_a = 1;
                    slot.func_75215_d(newStack);
                    slot.func_75218_e();
                    --stack.field_77994_a;
                    flag1 = true;
                    break;
                }
                if (reverse) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }
}

