/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.entities;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.apache.logging.log4j.Level;
import thaumcraft.common.entities.golems.EntityGolemBase;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.IGolemLinkableDevice;

public class GolemLink
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "AutomagyGolemLink";
    public static final int WATCHER_ID = 25;
    public final EntityGolemBase golem;
    private static Map<String, WorldSpecificCoordinates> coordCache = new HashMap<String, WorldSpecificCoordinates>();

    public GolemLink(EntityGolemBase golem, String linkID) {
        this.golem = golem;
        golem.func_70096_w().func_75682_a(25, (Object)linkID);
    }

    public GolemLink(EntityGolemBase golem) {
        this(golem, "");
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74778_a("linkID", this.getLinkID());
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.setLinkID(properties.func_74779_i("linkID"));
    }

    public String getLinkID() {
        return this.golem.func_70096_w().func_75681_e(25);
    }

    public void setLinkID(String linkID) {
        this.golem.func_70096_w().func_75692_b(25, (Object)linkID);
    }

    public static GolemLink get(EntityGolemBase golem) {
        return (GolemLink)golem.getExtendedProperties(EXT_PROP_NAME);
    }

    public static boolean golemLinkedTo(EntityGolemBase golem, IGolemLinkableDevice device) {
        String deviceLinkID = device.getGolemLinkID();
        if (deviceLinkID == null) {
            return false;
        }
        GolemLink link = GolemLink.get(golem);
        return link != null && deviceLinkID.equals(link.getLinkID());
    }

    public static IGolemLinkableDevice getLinkedDevice(EntityGolemBase golem) {
        IGolemLinkableDevice device;
        TileEntity te;
        WorldSpecificCoordinates coord = GolemLink.getCoordinatesFromLinkString(GolemLink.get(golem).getLinkID());
        if (coord != null && coord.dim == golem.field_70170_p.field_73011_w.field_76574_g && (te = golem.field_70170_p.func_147438_o(coord.x, coord.y, coord.z)) instanceof IGolemLinkableDevice && GolemLink.golemLinkedTo(golem, device = (IGolemLinkableDevice)te)) {
            return device;
        }
        return null;
    }

    public static GolemLink establishLink(EntityGolemBase golem, IGolemLinkableDevice device) {
        String linkID = device.getGolemLinkID();
        if (linkID == null) {
            FMLLog.log((Level)Level.ERROR, (String)"[Automagy] Failed to register golem extended properties. Linking golem to device failed!", (Object[])new Object[0]);
            return null;
        }
        GolemLink link = GolemLink.get(golem);
        if (link == null) {
            link = new GolemLink(golem, linkID);
            golem.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)link);
        } else {
            link.setLinkID(linkID);
        }
        return link;
    }

    public static GolemLink register(EntityGolemBase golem) {
        GolemLink link = new GolemLink(golem);
        golem.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)link);
        return link;
    }

    public static WorldSpecificCoordinates getCoordinatesFromLinkString(String link) {
        if (link == null || link.isEmpty()) {
            return null;
        }
        if (coordCache.containsKey(link)) {
            return coordCache.get(link);
        }
        String s = link.substring(link.lastIndexOf(58) + 1);
        String[] sCoord = s.split(",", 4);
        if (sCoord.length != 4) {
            return null;
        }
        int dim = Integer.parseInt(sCoord[0]);
        int x = Integer.parseInt(sCoord[1]);
        int y = Integer.parseInt(sCoord[2]);
        int z = Integer.parseInt(sCoord[3]);
        WorldSpecificCoordinates coord = new WorldSpecificCoordinates(dim, x, y, z);
        coordCache.put(link, coord);
        return coord;
    }
}

