/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.material.OreDictionaryPreferenceParser;
import crazypants.util.OreDictionaryHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictionaryPreferences {
    public static final OreDictionaryPreferences instance = new OreDictionaryPreferences();
    private Map<String, ItemStack> preferences = new HashMap<String, ItemStack>();
    private Map<StackKey, ItemStack> stackCache = new HashMap<StackKey, ItemStack>();

    public static void loadConfig() {
        OreDictionaryPreferenceParser.loadConfig();
    }

    public void setPreference(String oreDictName, ItemStack stack) {
        if (oreDictName == null || stack == null) {
            return;
        }
        this.preferences.put(oreDictName, stack.func_77946_l());
    }

    public ItemStack getPreferred(String oreDictName) {
        ItemStack result = null;
        if (this.preferences.containsKey(oreDictName)) {
            result = this.preferences.get(oreDictName);
        } else {
            List<ItemStack> ores = OreDictionaryHelper.getOres(oreDictName);
            if (!ores.isEmpty() && ores.get(0) != null) {
                result = ores.get(0).func_77946_l();
            }
            this.preferences.put(oreDictName, result);
        }
        return result;
    }

    public ItemStack getPreferred(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return stack;
        }
        StackKey key = new StackKey(stack);
        if (this.stackCache.containsKey(key)) {
            return this.stackCache.get(key);
        }
        ItemStack result = null;
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids != null) {
            for (int i = 0; i < ids.length && result == null; ++i) {
                String oreDict = OreDictionary.getOreName((int)ids[i]);
                if (!this.preferences.containsKey(oreDict)) continue;
                result = this.preferences.get(oreDict);
            }
        }
        if (result == null) {
            result = stack;
        }
        this.stackCache.put(key, result);
        return stack;
    }

    private static class StackKey {
        Item item;
        int damage;

        StackKey(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.damage = stack.func_77960_j();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.damage;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StackKey other = (StackKey)obj;
            if (this.damage != other.damage) {
                return false;
            }
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }
}

