/*
 * Decompiled with CFR 0.152.
 */
package openeye.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openeye.storage.GsonDirStorage;
import openeye.storage.IDataSource;
import openeye.storage.IWorkingStorage;

public class GsonWorkingStorage<T>
extends GsonDirStorage<T>
implements IWorkingStorage<T> {
    private final Map<String, IDataSource<T>> sources = Maps.newHashMap();

    public GsonWorkingStorage(File dir, String prefix, Class<? extends T> cls, Gson gson) {
        super(dir, prefix, cls, gson, "json");
        Pattern filePattern = Pattern.compile(prefix + "-(.+)\\.json");
        for (File file : dir.listFiles()) {
            String name = file.getName();
            Matcher m = filePattern.matcher(name);
            if (!m.matches()) continue;
            String id = m.group(1);
            this.sources.put(id, this.createFromFile(id, file));
        }
    }

    @Override
    protected synchronized void removeEntry(String id) {
        this.sources.remove(id);
    }

    @Override
    public synchronized Collection<IDataSource<T>> listAll() {
        return ImmutableList.copyOf(this.sources.values());
    }

    @Override
    public synchronized IDataSource<T> getById(String id) {
        return this.sources.get(id);
    }

    @Override
    public synchronized IDataSource<T> createNew() {
        String id;
        String idPrefix = GsonWorkingStorage.generateId();
        int count = 0;
        while (this.sources.containsKey(id = idPrefix + "-" + count++)) {
        }
        return this.createNew(id);
    }

    @Override
    public synchronized IDataSource<T> createNew(String id) {
        IDataSource newSource = super.createNew(id);
        this.sources.put(id, newSource);
        return newSource;
    }
}

