/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.hats;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonHatEntities
implements IWailaEntityProvider {
    static HashMap<File, String> hatMap = null;
    private static String showHats = "wawla.showHat";

    public Entity getWailaOverride(IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return data.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        NBTTagCompound forgeTag;
        if (cfg.getConfig(showHats) && data.getNBTData() != null && data.getNBTData().func_74764_b("ForgeData") && (forgeTag = data.getNBTData().func_74775_l("ForgeData")).func_74764_b("Hats_hatInfo") && !forgeTag.func_74779_i("Hats_hatInfo").isEmpty()) {
            String hatName = this.getHatFromList(forgeTag.func_74779_i("Hats_hatInfo"));
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.hats") + ": " + hatName.substring(0, hatName.length() - 4));
        }
        return tip;
    }

    public List<String> getWailaTail(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        if (entity != null) {
            entity.func_70109_d(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonHatEntities dataProvider = new AddonHatEntities();
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, Entity.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, Entity.class);
        register.addConfig("Wawla-Entity", showHats);
        try {
            Class<?> classHatHandler = Class.forName("hats.common.core.HatHandler");
            Method getHatNames = null;
            for (Method method : classHatHandler.getDeclaredMethods()) {
                if (!method.getName().equalsIgnoreCase("getHatNames")) continue;
                getHatNames = method;
            }
            hatMap = (HashMap)getHatNames.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String getHatFromList(String name) {
        for (Map.Entry<File, String> entry : hatMap.entrySet()) {
            String value = entry.getValue();
            if (!value.equalsIgnoreCase(name)) continue;
            File hat = entry.getKey();
            return hat.getName();
        }
        return "null";
    }
}

