/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;

public abstract class McBlockPart
extends JCuboidPart
implements JNormalOcclusion,
JIconHitEffects {
    public abstract Block getBlock();

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply(this, npart);
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    @Override
    public Iterable<Cuboid6> getCollisionBoxes() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(new ItemStack(this.getBlock()));
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(this.getBlock());
    }

    @Override
    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return this.getBlock().func_149737_a(player, player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d) * 30.0f;
    }

    @Override
    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getBlock().func_149691_a(0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBrokenIcon(int side) {
        return this.getBlock().func_149691_a(0, 0);
    }

    @Override
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects(this, hit, effectRenderer);
    }

    @Override
    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects(this, effectRenderer, false);
    }

    @Override
    public int getLightValue() {
        return this.getBlock().func_149750_m();
    }
}

