/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks;

import com.nauktis.core.block.BaseModBlockWithTileEntity;
import com.nauktis.core.utility.Utils;
import com.nauktis.solarflux.SolarFluxMod;
import com.nauktis.solarflux.blocks.SolarPanelTileEntity;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.creativetab.ModCreativeTab;
import com.nauktis.solarflux.utility.Lang;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SolarPanelBlock
extends BaseModBlockWithTileEntity {
    protected final int mMaximumEnergyGeneration;
    protected final int mMaximumEnergyTransfer;
    protected final int mEnergyCapacity;
    private IIcon mBlockSideIcon;

    public SolarPanelBlock(String pName, int pMaximumEnergyGeneration, int pEnergyCapacity) {
        super("SolarFlux", pName);
        this.mMaximumEnergyGeneration = pMaximumEnergyGeneration;
        this.mMaximumEnergyTransfer = this.mMaximumEnergyGeneration * 8;
        this.mEnergyCapacity = pEnergyCapacity;
        this.func_149647_a(ModCreativeTab.MOD_TAB);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149777_j);
        if (!ModConfiguration.isSolarPanelFullBlock()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, ModConfiguration.getSolarPanelHeight(), 1.0f);
            this.func_149713_g(255);
            this.field_149783_u = true;
        }
    }

    public boolean func_149686_d() {
        return ModConfiguration.isSolarPanelFullBlock() && super.func_149686_d();
    }

    public boolean func_149662_c() {
        return ModConfiguration.isSolarPanelFullBlock() && super.func_149662_c();
    }

    public int getMaximumEnergyGeneration() {
        return this.mMaximumEnergyGeneration;
    }

    public int getMaximumEnergyTransfer() {
        return this.mMaximumEnergyTransfer;
    }

    public int getEnergyCapacity() {
        return this.mEnergyCapacity;
    }

    public TileEntity func_149915_a(World pWorld, int pMetadata) {
        return new SolarPanelTileEntity(this.mMaximumEnergyGeneration, this.mMaximumEnergyTransfer, this.mEnergyCapacity);
    }

    public IIcon func_149691_a(int pSide, int pMetadata) {
        if (ForgeDirection.UP == ForgeDirection.getOrientation((int)pSide)) {
            return super.func_149691_a(pSide, pMetadata);
        }
        return this.mBlockSideIcon;
    }

    public void func_149689_a(World pWorld, int pX, int pY, int pZ, EntityLivingBase pEntity, ItemStack pItemStack) {
        if (pItemStack.field_77990_d != null) {
            SolarPanelTileEntity localTileCell = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ);
            localTileCell.setEnergyStored(pItemStack.field_77990_d.func_74762_e("SFESEnergy"));
        }
        super.func_149689_a(pWorld, pX, pY, pZ, pEntity, pItemStack);
    }

    public boolean func_149727_a(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer, int pSide, float pdx, float pdy, float pdz) {
        if (Utils.isServer(pWorld) && pPlayer.func_70093_af()) {
            if (Utils.hasUsableWrench(pPlayer, pX, pY, pZ)) {
                this.dismantleBlock(pWorld, pX, pY, pZ);
                return true;
            }
            this.displayChatInformation(pWorld, pX, pY, pZ, pPlayer);
            return true;
        }
        return false;
    }

    private void displayChatInformation(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer) {
        SolarPanelTileEntity tile = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ);
        String message = String.format("%s: [%d%%] %,d / %,d %s: %,d", Lang.localise("energy.stored"), tile.getPercentageEnergyStored(), tile.getEnergyStored(), tile.getMaxEnergyStored(), Lang.localise("energy.generation"), tile.getEnergyProduced());
        pPlayer.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    private void dismantleBlock(World pWorld, int pX, int pY, int pZ) {
        ItemStack itemStack = new ItemStack((Block)this);
        if (ModConfiguration.doesKeepEnergyWhenDismantled()) {
            SolarPanelTileEntity localTileCell = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ);
            int internalEnergy = localTileCell.getEnergyStored();
            if (internalEnergy > 0) {
                if (itemStack.func_77978_p() == null) {
                    itemStack.func_77982_d(new NBTTagCompound());
                }
                itemStack.func_77978_p().func_74768_a("SFESEnergy", internalEnergy);
            }
            SolarFluxMod.log.trace("Dismantled solar panel with %,d RF.", internalEnergy);
        }
        pWorld.func_147468_f(pX, pY, pZ);
        Utils.spawnItemStack(pWorld, pX, pY, pZ, itemStack);
    }

    public void func_149651_a(IIconRegister pIconRegister) {
        super.func_149651_a(pIconRegister);
        this.mBlockSideIcon = pIconRegister.func_94245_a(this.func_149641_N() + "_side");
    }
}

