/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.qnb.TileQuantumBridge;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderQNB
extends BaseBlockRender {
    @Override
    public void renderInventory(AEBaseBlock block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        float minPx = 0.125f;
        float maxPx = 0.875f;
        renderer.func_147782_a((double)minPx, (double)minPx, (double)minPx, (double)maxPx, (double)maxPx, (double)maxPx);
        super.renderInventory(block, item, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TileQuantumBridge tqb = (TileQuantumBridge)block.getTileEntity(world, x, y, z);
        if (tqb == null) {
            return false;
        }
        renderer.field_147837_f = true;
        IDefinitions definitions = AEApi.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IParts parts = definitions.parts();
        for (Block linkBlock : blocks.quantumLink().maybeBlock().asSet()) {
            float renderMax;
            if (tqb.func_145838_q() == linkBlock) {
                if (tqb.isFormed()) {
                    EnumSet<ForgeDirection> sides = tqb.getConnections();
                    Item transGlassCable = parts.cableGlass().item(AEColor.Transparent);
                    this.renderCableAt(0.11, world, x, y, z, block, renderer, transGlassCable.func_77650_f(parts.cableGlass().stack(AEColor.Transparent, 1)), 0.141, sides);
                    Item transCoveredCable = parts.cableCovered().item(AEColor.Transparent);
                    this.renderCableAt(0.188, world, x, y, z, block, renderer, transCoveredCable.func_77650_f(parts.cableCovered().stack(AEColor.Transparent, 1)), 0.1875, sides);
                }
                float renderMin = 0.125f;
                renderMax = 0.875f;
                renderer.func_147782_a((double)renderMin, (double)renderMin, (double)renderMin, (double)renderMax, (double)renderMax, (double)renderMax);
                renderer.func_147784_q((Block)block, x, y, z);
                continue;
            }
            if (!tqb.isFormed()) {
                float renderMin = 0.125f;
                renderMax = 0.875f;
                renderer.func_147782_a((double)renderMin, (double)renderMin, (double)renderMin, (double)renderMax, (double)renderMax, (double)renderMax);
                renderer.func_147784_q((Block)block, x, y, z);
                continue;
            }
            if (tqb.isCorner()) {
                Item transCoveredCable = parts.cableCovered().item(AEColor.Transparent);
                this.renderCableAt(0.188, world, x, y, z, block, renderer, transCoveredCable.func_77650_f(parts.cableCovered().stack(AEColor.Transparent, 1)), 0.05, tqb.getConnections());
                float renderMin = 0.25f;
                float renderMax2 = 0.75f;
                renderer.func_147782_a((double)renderMin, (double)renderMin, (double)renderMin, (double)renderMax2, (double)renderMax2, (double)renderMax2);
                renderer.func_147784_q((Block)block, x, y, z);
                if (!tqb.isPowered()) continue;
                renderMin = 0.24375f;
                renderMax2 = 0.75625f;
                renderer.func_147782_a((double)renderMin, (double)renderMin, (double)renderMin, (double)renderMax2, (double)renderMax2, (double)renderMax2);
                int bn = 15;
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(x, y, z, (Block)block, ExtraBlockTextures.BlockQRingCornerLight.getIcon(), renderer, side);
                }
                continue;
            }
            float renderMin = 0.125f;
            renderMax = 0.875f;
            renderer.func_147782_a(0.0, (double)renderMin, (double)renderMin, 1.0, (double)renderMax, (double)renderMax);
            renderer.func_147784_q((Block)block, x, y, z);
            renderer.func_147782_a((double)renderMin, 0.0, (double)renderMin, (double)renderMax, 1.0, (double)renderMax);
            renderer.func_147784_q((Block)block, x, y, z);
            renderer.func_147782_a((double)renderMin, (double)renderMin, 0.0, (double)renderMax, (double)renderMax, 1.0);
            renderer.func_147784_q((Block)block, x, y, z);
            if (!tqb.isPowered()) continue;
            renderMin = -6.25E-4f;
            renderMax = 1.000625f;
            renderer.func_147782_a((double)renderMin, (double)renderMin, (double)renderMin, (double)renderMax, (double)renderMax, (double)renderMax);
            int bn = 15;
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                this.renderFace(x, y, z, (Block)block, ExtraBlockTextures.BlockQRingEdgeLight.getIcon(), renderer, side);
            }
        }
        renderer.field_147837_f = false;
        return true;
    }

    public void renderCableAt(double thickness, IBlockAccess world, int x, int y, int z, AEBaseBlock block, RenderBlocks renderer, IIcon texture, double pull, Collection<ForgeDirection> connections) {
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (connections.contains(ForgeDirection.UNKNOWN)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 - thickness, 0.5 - thickness, 0.5 + thickness, 0.5 + thickness, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.WEST)) {
            renderer.func_147782_a(0.0, 0.5 - thickness, 0.5 - thickness, 0.5 - thickness - pull, 0.5 + thickness, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.EAST)) {
            renderer.func_147782_a(0.5 + thickness + pull, 0.5 - thickness, 0.5 - thickness, 1.0, 0.5 + thickness, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.NORTH)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 - thickness, 0.0, 0.5 + thickness, 0.5 + thickness, 0.5 - thickness - pull);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.SOUTH)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 - thickness, 0.5 + thickness + pull, 0.5 + thickness, 0.5 + thickness, 1.0);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.DOWN)) {
            renderer.func_147782_a(0.5 - thickness, 0.0, 0.5 - thickness, 0.5 + thickness, 0.5 - thickness - pull, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.UP)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 + thickness + pull, 0.5 - thickness, 0.5 + thickness, 1.0, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        block.getRendererInstance().setTemporaryRenderIcon(null);
    }
}

