/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.fsp.handlers;

import flaxbeard.steamcraft.api.CrucibleFormula;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.Tuple3;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.fsp.FSPHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.MutablePair;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.fsp.Crucible")
public class Crucible {
    @ZenMethod
    public static void addLiquid(String name, IItemStack ingot, IItemStack plate, IItemStack nugget, int r, int g, int b) {
        MineTweakerAPI.apply((IUndoableAction)new AddLiquid(new CrucibleLiquid(name, InputHelper.toStack(ingot), InputHelper.toStack(plate), InputHelper.toStack(nugget), null, r, g, b)));
    }

    @ZenMethod
    public static void addLiquid(String name, IItemStack ingot, IItemStack plate, IItemStack nugget, int r, int g, int b, String l1, int n1, String l2, int n2, int n3) {
        MineTweakerAPI.apply((IUndoableAction)new AddLiquid(new CrucibleLiquid(name, InputHelper.toStack(ingot), InputHelper.toStack(plate), InputHelper.toStack(nugget), new CrucibleFormula(FSPHelper.getLiquid(l1), n1, FSPHelper.getLiquid(l2), n2, n3), r, g, b)));
    }

    @ZenMethod
    public static void addMelting(IItemStack input, String liquid, int volume) {
        ItemStack stack = InputHelper.toStack(input);
        CrucibleLiquid fluid = FSPHelper.getLiquid(liquid);
        if (fluid != null) {
            MineTweakerAPI.apply((IUndoableAction)new AddMelting(stack, (Object)MutablePair.of((Object)stack.func_77973_b(), (Object)stack.func_77960_j()), (Object)MutablePair.of((Object)fluid, (Object)volume)));
        }
    }

    @ZenMethod
    public static void removeMelting(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveMelting(InputHelper.toStack(input), MutablePair.of((Object)InputHelper.toStack(input).func_77973_b(), (Object)InputHelper.toStack(input).func_77960_j())));
    }

    @ZenMethod
    public static void addDunking(IItemStack input, String liquid, int volume, IItemStack output) {
        ItemStack stack = InputHelper.toStack(input);
        CrucibleLiquid fluid = FSPHelper.getLiquid(liquid);
        if (fluid != null) {
            MineTweakerAPI.apply((IUndoableAction)new AddDunking(InputHelper.toStack(input), (Object)new Tuple3((Object)stack.func_77973_b(), (Object)stack.func_77960_j(), (Object)fluid), (Object)MutablePair.of((Object)volume, (Object)InputHelper.toStack(output))));
        }
    }

    @ZenMethod
    public static void removeDunking(IItemStack input, String liquid) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveDunking(InputHelper.toStack(input), new Tuple3((Object)InputHelper.toStack(input).func_77973_b(), (Object)InputHelper.toStack(input).func_77960_j(), (Object)FSPHelper.getLiquid(liquid))));
    }

    private static class RemoveDunking
    extends BaseMapRemoval {
        private final ItemStack stack;

        public RemoveDunking(ItemStack stack, Object key) {
            super("FSP Crucible Dunking", (Map)SteamcraftRegistry.dunkThings, key);
            this.stack = stack;
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class AddDunking
    extends BaseMapAddition {
        private final ItemStack stack;

        public AddDunking(ItemStack stack, Object key, Object recipe) {
            super("FSP Crucible Dunking", SteamcraftRegistry.dunkThings, key, recipe);
            this.stack = stack;
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class RemoveMelting
    extends BaseMapRemoval {
        private final ItemStack stack;

        public RemoveMelting(ItemStack stack, Object key) {
            super("FSP Crucible Melting", (Map)SteamcraftRegistry.smeltThings, key);
            this.stack = stack;
        }

        @Override
        public void apply() {
            SteamcraftRegistry.smeltThings.remove(this.stack);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class AddMelting
    extends BaseMapAddition {
        private final ItemStack stack;

        public AddMelting(ItemStack stack, Object key, Object recipe) {
            super("FSP Crucible Melting", SteamcraftRegistry.smeltThings, key, recipe);
            this.stack = stack;
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class AddLiquid
    extends BaseListAddition {
        public AddLiquid(CrucibleLiquid recipe) {
            super("FSP Crucible Liquid", SteamcraftRegistry.liquids, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((CrucibleLiquid)this.recipe).name;
        }
    }
}

