/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.base.Strings;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.OpenBlocksGuiHandler;
import openblocks.common.entity.ai.EntityAICollectItem;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.legacy.ItemDistribution;

public class EntityLuggage
extends EntityTameable
implements IInventoryProvider,
IEntityAdditionalSpawnData {
    private static final String TAG_SHINY = "shiny";
    protected GenericInventory inventory = this.createInventory(27);
    public boolean special;
    public int lastSound = 0;

    private GenericInventory createInventory(int size) {
        return new GenericInventory("luggage", false, size){

            public boolean func_70300_a(EntityPlayer player) {
                return !EntityLuggage.this.field_70128_L && player.func_70068_e((Entity)EntityLuggage.this) < 64.0;
            }
        };
    }

    public EntityLuggage(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70659_e(0.7f);
        this.func_70657_f(0.0f);
        this.func_70903_f(true);
        this.func_110163_bv();
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, (double)this.func_70689_ay(), 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICollectItem(this));
        this.field_70180_af.func_75682_a(18, (Object)this.inventory.func_70302_i_());
    }

    public void setSpecial() {
        if (this.special) {
            return;
        }
        this.special = true;
        GenericInventory inventory = this.createInventory(54);
        inventory.copyFrom((IInventory)this.inventory);
        if (this.field_70180_af != null) {
            this.field_70180_af.func_75692_b(18, (Object)inventory.func_70302_i_());
        }
        this.inventory = inventory;
    }

    public boolean isSpecial() {
        if (this.field_70170_p.field_72995_K) {
            return this.inventory.func_70302_i_() > 27;
        }
        return this.special;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            int inventorySize = this.field_70180_af.func_75679_c(18);
            if (this.inventory.func_70302_i_() != inventorySize) {
                this.inventory = this.createInventory(inventorySize);
            }
        }
        ++this.lastSound;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public GenericInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return this.convertToItem();
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70128_L) {
            if (this.field_70170_p.field_72995_K) {
                if (player.func_70093_af()) {
                    this.spawnPickupParticles();
                }
            } else if (player.func_70093_af()) {
                ItemStack luggageItem = this.convertToItem();
                if (player.field_71071_by.func_70441_a(luggageItem)) {
                    this.func_70106_y();
                }
                this.func_85030_a("random.pop", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            } else {
                this.func_85030_a("random.chestopen", 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                player.openGui((Object)OpenBlocks.instance, OpenBlocksGuiHandler.GuiId.luggage.ordinal(), player.field_70170_p, this.func_145782_y(), 0, 0);
            }
        }
        return true;
    }

    protected void spawnPickupParticles() {
        double py = this.field_70163_u + (double)this.field_70131_O;
        for (int i = 0; i < 50; ++i) {
            double vx = this.field_70146_Z.nextGaussian() * 0.02;
            double vz = this.field_70146_Z.nextGaussian() * 0.02;
            double px = this.field_70165_t + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            double pz = this.field_70161_v + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            this.field_70170_p.func_72869_a("portal", px, py, pz, vx, -1.0, vz);
        }
    }

    protected ItemStack convertToItem() {
        ItemStack luggageItem = new ItemStack((Item)OpenBlocks.Items.luggage);
        NBTTagCompound tag = new NBTTagCompound();
        this.inventory.writeToNBT(tag);
        luggageItem.func_77982_d(tag);
        String nameTag = this.func_94057_bL();
        if (!Strings.isNullOrEmpty((String)nameTag)) {
            luggageItem.func_151001_c(nameTag);
        }
        return luggageItem;
    }

    public boolean canConsumeStackPartially(ItemStack stack) {
        return ItemDistribution.testInventoryInsertion((IInventory)this.inventory, (ItemStack)stack) > 0;
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("openblocks:luggage.walk", 0.3f, 0.7f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a(TAG_SHINY, this.special);
        this.inventory.writeToNBT(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74767_n(TAG_SHINY)) {
            this.setSpecial();
        }
        this.inventory.readFromNBT(tag);
    }

    public void func_70077_a(EntityLightningBolt lightning) {
        this.setSpecial();
    }

    public boolean func_85032_ar() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.inventory.func_70302_i_());
    }

    public void readSpawnData(ByteBuf data) {
        this.inventory = this.createInventory(data.readInt());
    }

    public double func_70042_X() {
        return 0.825;
    }
}

