/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelLabel;
import jds.bibliocraft.models.OBJLabel;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemLabelRenderer
implements IItemRenderer {
    private ModelLabel labelModel;
    private OBJLabel objModel = new OBJLabel();
    private static boolean useTextureSheet;

    public ItemLabelRenderer() {
        this.labelModel = new ModelLabel();
        useTextureSheet = this.usesTextureSheet();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int metaTest = item.func_77960_j();
        String textureLoc = "none";
        NBTTagCompound tags = item.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            textureLoc = tags.func_74779_i("renderTexture");
        }
        switch (type) {
            case ENTITY: {
                this.renderWoodLabel(0.0f, -0.1f, 0.0f, metaTest, true, textureLoc);
                break;
            }
            case EQUIPPED: {
                this.renderWoodLabel(0.6f, 1.0f, 0.8f, metaTest, false, textureLoc);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderWoodLabel(0.6f, 1.0f, 0.8f, metaTest, false, textureLoc);
                break;
            }
            case INVENTORY: {
                this.renderWoodLabel(0.8f, 0.66f, 0.76f, metaTest, false, textureLoc);
                break;
            }
        }
    }

    private void renderWoodLabel(float i, float j, float k, int metaData, boolean entity, String texLoc) {
        float scale = 0.083333336f;
        Tessellator tesselator = Tessellator.field_78398_a;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)i, (float)j, (float)k);
        if (entity) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (useTextureSheet && metaData != 6) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
            this.labelModel.renderLabel(scale);
        } else {
            if (texLoc.contentEquals("none")) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getVanillaWoodTexture(metaData));
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(BiblioRenderHelper.getBlockResource(texLoc));
            }
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScaled((double)2.6f, (double)2.6f, (double)2.6f);
            this.objModel.render();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.WOODLABEL0_PNG;
            }
            case 1: {
                return CommonProxy.WOODLABEL1_PNG;
            }
            case 2: {
                return CommonProxy.WOODLABEL2_PNG;
            }
            case 3: {
                return CommonProxy.WOODLABEL3_PNG;
            }
            case 4: {
                return CommonProxy.WOODLABEL4_PNG;
            }
            case 5: {
                return CommonProxy.WOODLABEL5_PNG;
            }
        }
        return CommonProxy.WOODLABEL0_PNG;
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
            case 6: {
                return CommonProxy.FRAME_BLOCK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }

    public boolean usesTextureSheet() {
        return Config.useTextureSheet;
    }
}

