/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.thermaldynamics.duct.attachments.facades.Cover;
import cofh.thermaldynamics.duct.attachments.facades.CoverHelper;
import cofh.thermaldynamics.duct.attachments.facades.CoverRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ItemCoverRenderer
implements IItemRenderer {
    public static IItemRenderer instance = new ItemCoverRenderer();

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null || !nBTTagCompound.func_150297_b("Meta", 1) || !nBTTagCompound.func_150297_b("Block", 8)) {
            return;
        }
        byte by = nBTTagCompound.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nBTTagCompound.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || by < 0 || by >= 16 || !CoverHelper.isValid(block, by)) {
            nBTTagCompound.func_82580_o("Meta");
            nBTTagCompound.func_82580_o("Block");
            if (nBTTagCompound.func_82582_d()) {
                itemStack.func_77982_d(null);
            }
        }
        GL11.glPushMatrix();
        double d = -0.5;
        if (itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED || itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            d = 0.0;
        } else if (itemRenderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        }
        RenderHelper.setBlockTextureSheet();
        RenderUtils.preItemRender();
        CCRenderState.startDrawing();
        GL11.glTranslated((double)d, (double)(d - 128.0), (double)d);
        SingleBlockAccess.instance.block = block;
        SingleBlockAccess.instance.meta = by;
        CoverRenderer.renderBlocks.field_147845_a = SingleBlockAccess.instance;
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        ForgeDirection forgeDirection = itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON ? ForgeDirection.WEST : ForgeDirection.SOUTH;
        GL11.glTranslated((double)((double)(-forgeDirection.offsetX) * 0.5), (double)((double)(-forgeDirection.offsetY) * 0.5), (double)((double)(-forgeDirection.offsetZ) * 0.5));
        for (int i = 0; i < 2; ++i) {
            if (!block.canRenderInPass(i)) continue;
            CoverRenderer.renderCover(CoverRenderer.renderBlocks, 0, 128, 0, forgeDirection.ordinal(), block, by, Cover.bounds[forgeDirection.ordinal()], true, false);
        }
        CCRenderState.draw();
        CCRenderState.useNormals = false;
        RenderHelper.setItemTextureSheet();
        RenderUtils.postItemRender();
        GL11.glPopMatrix();
    }

    public static class SingleBlockAccess
    implements IBlockAccess {
        public static SingleBlockAccess instance = new SingleBlockAccess();
        public Block block;
        public int meta;

        public boolean isLoc(int n, int n2, int n3) {
            return n == 0 && n2 == 128 && n3 == 0;
        }

        public SingleBlockAccess() {
        }

        public SingleBlockAccess(Block block, int n) {
            this.block = block;
            this.meta = n;
        }

        public Block func_147439_a(int n, int n2, int n3) {
            return this.isLoc(n, n2, n3) ? this.block : Blocks.field_150350_a;
        }

        public TileEntity func_147438_o(int n, int n2, int n3) {
            return null;
        }

        public int func_72802_i(int n, int n2, int n3, int n4) {
            return 0xF000F0;
        }

        public int func_72805_g(int n, int n2, int n3) {
            return this.isLoc(n, n2, n3) ? this.meta : 0;
        }

        public int func_72879_k(int n, int n2, int n3, int n4) {
            return 0;
        }

        public boolean func_147437_c(int n, int n2, int n3) {
            return this.isLoc(n, n2, n3);
        }

        public BiomeGenBase func_72807_a(int n, int n2) {
            return BiomeGenBase.field_76772_c;
        }

        public int func_72800_K() {
            return 140;
        }

        public boolean func_72806_N() {
            return false;
        }

        public boolean isSideSolid(int n, int n2, int n3, ForgeDirection forgeDirection, boolean bl) {
            return this.isLoc(n, n2, n3) && this.block.isSideSolid((IBlockAccess)this, n, n2, n3, forgeDirection);
        }
    }
}

