/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.ENBlocks;
import exnihilo.ExNihilo;
import exnihilo.data.ModData;
import exnihilo.items.seeds.ItemSeedRubber;
import exnihilo.registries.CompostRegistry;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.Color;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class IC2 {
    public static boolean isLoaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static void loadCompatibility() {
        ArrayList ores = OreDictionary.getOres((String)"dustSulfur");
        if (ores.size() > 0) {
            ItemStack sulfur = ores.toArray(new ItemStack[ores.size()])[0];
            SieveRegistry.register(ENBlocks.Dust, 0, sulfur.func_77973_b(), sulfur.func_77960_j(), 32);
            ExNihilo.log.info("Sulfur was successfully integrated");
        } else {
            ExNihilo.log.error("SULFUR WAS NOT INTEGRATED");
        }
        Block rubberSapling = GameRegistry.findBlock((String)"IC2", (String)"blockRubSapling");
        if (rubberSapling != null) {
            ItemSeedRubber.AddSapling(rubberSapling);
            ExNihilo.log.info("Rubber was successfully integrated");
        } else {
            ExNihilo.log.error("RUBBER WAS NOT INTEGRATED");
        }
        Item crushedOres = GameRegistry.findItem((String)"IC2", (String)"itemCrushedOre");
        if (crushedOres != null) {
            SieveRegistry.register((Block)Blocks.field_150354_m, 0, crushedOres, 4, 48);
            ExNihilo.log.info("Crushed Ores were successfully integrated");
        } else {
            ExNihilo.log.error("CRUSHED ORES WERE NOT INTEGRATED");
        }
        Item plantBall = GameRegistry.findItem((String)"IC2", (String)"itemFuelPlantBall");
        if (plantBall != null) {
            CompostRegistry.register(plantBall, 0, 0.5f, new Color("269900"));
            ExNihilo.log.info("Plantball was successfully integrated");
        } else {
            ExNihilo.log.error("PLANTBALL WAS NOT INTEGRATED");
        }
        Item plantBallCompressed = GameRegistry.findItem((String)"IC2", (String)"itemFuelPlantCmpr");
        if (plantBallCompressed != null) {
            CompostRegistry.register(plantBallCompressed, 0, 1.0f, new Color("269900"));
            ExNihilo.log.info("Compressed Plants were successfully integrated");
        } else {
            ExNihilo.log.error("COMPRESSED PLANTS WERE NOT INTEGRATED");
        }
        if (ModData.OVERWRITE_DEFAULT_MACERATOR_RECIPES) {
            Map recipes = Recipes.macerator.getRecipes();
            IRecipeInput cobbleRecipe = null;
            IRecipeInput gravelRecipe = null;
            for (IRecipeInput i : recipes.keySet()) {
                if (i.matches(new ItemStack(Blocks.field_150347_e))) {
                    cobbleRecipe = i;
                }
                if (!i.matches(new ItemStack(Blocks.field_150351_n))) continue;
                gravelRecipe = i;
            }
            if (cobbleRecipe != null) {
                recipes.remove(cobbleRecipe);
                ExNihilo.log.info("Macerator: removed default cobble->sand Macerator recipe");
            } else {
                ExNihilo.log.error("DEFAULT COBBLE TO SAND MACERATOR RECIPE WASN'T REMOVED");
            }
            if (gravelRecipe != null) {
                recipes.remove(gravelRecipe);
                ExNihilo.log.info("Macerator: removed default gravel->flint Macerator recipe");
            } else {
                ExNihilo.log.error("DEFAULT GRAVEL TO FLINT MACERATOR RECIPE WASN'T REMOVED");
            }
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(Blocks.field_150347_e)), null, new ItemStack[]{new ItemStack(Blocks.field_150351_n)});
            ExNihilo.log.info("Macerator: added recipe for cobble->gravel");
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(Blocks.field_150351_n)), null, new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m)});
            ExNihilo.log.info("Macerator: added recipe for gravel->sand");
        }
        Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Block)Blocks.field_150354_m)), null, new ItemStack[]{new ItemStack(ENBlocks.Dust)});
        ExNihilo.log.info("Macerator: added recipe sand->dust");
        ExNihilo.log.info("--- IC2 Integration Complete!");
    }
}

