/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.item;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsMod;
import com.rwtema.extrautils.ICreativeTabSorting;
import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ItemNodeUpgrade
extends Item
implements ICreativeTabSorting {
    private static final int numUpgrades = 10;
    private IIcon[] icons = new IIcon[10];

    public ItemNodeUpgrade() {
        this.func_77627_a(true);
        this.func_77655_b("extrautils:nodeUpgrade");
        this.func_77637_a(ExtraUtils.creativeTabExtraUtils);
    }

    public static boolean hasKey(ItemStack filter, String key) {
        NBTTagCompound tags;
        return filter != null && (tags = filter.func_77978_p()) != null && tags.func_74764_b(key);
    }

    public static boolean getPolarity(ItemStack filter) {
        return ItemNodeUpgrade.hasKey(filter, "Inverted");
    }

    public static boolean getFuzzyMetadata(ItemStack filter) {
        return ItemNodeUpgrade.hasKey(filter, "FuzzyMeta");
    }

    public static boolean getFuzzyNBT(ItemStack filter) {
        return ItemNodeUpgrade.hasKey(filter, "FuzzyNBT");
    }

    public static boolean matchesFilterBuffer(INodeBuffer item, ItemStack filter) {
        if (item == null || item.getBuffer() == null) {
            return false;
        }
        if (item.getBuffer() instanceof ItemStack) {
            return ItemNodeUpgrade.matchesFilterItem((ItemStack)item.getBuffer(), filter);
        }
        return !(item.getBuffer() instanceof FluidTank) || ItemNodeUpgrade.matchesFilterLiquid(((FluidTank)item.getBuffer()).getFluid(), filter);
    }

    public static boolean isFilter(ItemStack filter) {
        return ExtraUtils.nodeUpgrade != null && filter.func_77973_b() == ExtraUtils.nodeUpgrade && filter.func_77960_j() == 1;
    }

    public static boolean matchesFilterItem(ItemStack item, ItemStack filter) {
        if (ExtraUtils.nodeUpgrade != null && filter != null && filter.func_77973_b() == ExtraUtils.nodeUpgrade && filter.func_77960_j() == 1) {
            boolean polarity = !ItemNodeUpgrade.getPolarity(filter);
            boolean fuzzyMeta = ItemNodeUpgrade.getFuzzyMetadata(filter);
            boolean fuzzyNBT = ItemNodeUpgrade.getFuzzyNBT(filter);
            NBTTagCompound tags = filter.func_77978_p();
            if (tags != null) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack f;
                    if (!tags.func_74764_b("items_" + i) || (f = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("items_" + i))) == null) continue;
                    if (XUHelper.canItemsStack(f, item, fuzzyMeta, true, fuzzyNBT)) {
                        return polarity;
                    }
                    if (!ItemNodeUpgrade.isFilter(f) || !ItemNodeUpgrade.matchesFilterItem(item, f)) continue;
                    return polarity;
                }
            }
            return !polarity;
        }
        return XUHelper.canItemsStack(item, filter, false, true);
    }

    public static boolean matchesFilterLiquid(FluidStack liquid, ItemStack filter) {
        if (ExtraUtils.nodeUpgrade != null && filter.func_77973_b() == ExtraUtils.nodeUpgrade && filter.func_77960_j() == 1 && liquid != null) {
            boolean polarity = !ItemNodeUpgrade.getPolarity(filter);
            NBTTagCompound tags = filter.func_77978_p();
            if (tags != null) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack f;
                    if (!tags.func_74764_b("items_" + i) || (f = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("items_" + i))) == null) continue;
                    if (liquid.isFluidEqual(f)) {
                        return polarity;
                    }
                    if (!ItemNodeUpgrade.isFilter(f) || !ItemNodeUpgrade.matchesFilterLiquid(liquid, f)) continue;
                    return polarity;
                }
            }
            return !polarity;
        }
        return liquid != null && liquid.isFluidEqual(filter);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IIconRegister) {
        this.icons[0] = par1IIconRegister.func_94245_a("extrautils:nodeUpgrade");
        this.icons[1] = par1IIconRegister.func_94245_a("extrautils:filter");
        this.icons[2] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradeMining");
        this.icons[3] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradeStack");
        this.icons[4] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradeCreative");
        this.icons[5] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradeEnder");
        this.icons[6] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradeEnderReceiver");
        this.icons[7] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradeDepth");
        this.icons[8] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradeBreadth");
        this.icons[9] = par1IIconRegister.func_94245_a("extrautils:nodeUpgradePatience");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.icons[par1 % 10];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 10; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (item.func_77960_j() == 1 && item.func_77978_p() != null) {
            if (ItemNodeUpgrade.getPolarity(item)) {
                par3List.add("Inverted");
            }
            if (ItemNodeUpgrade.getFuzzyMetadata(item)) {
                par3List.add("Fuzzy - Ignores Metadata");
            }
            if (ItemNodeUpgrade.getFuzzyNBT(item)) {
                par3List.add("Fuzzy - Ignores NBT");
            }
            for (int i = 0; i < 9; ++i) {
                if (!item.func_77978_p().func_74764_b("items_" + i)) continue;
                ItemStack temp = ItemStack.func_77949_a((NBTTagCompound)item.func_77978_p().func_74775_l("items_" + i));
                List tempList = temp.func_82840_a(par2EntityPlayer, false);
                for (int j = 0; j < tempList.size(); ++j) {
                    if (j == 0) {
                        par3List.add("  " + tempList.get(j));
                        continue;
                    }
                    par3List.add("     " + tempList.get(j));
                }
                tempList.clear();
            }
        }
        if (item.func_77960_j() == 5 || item.func_77960_j() == 6) {
            par3List.set(0, ((String)par3List.get(0)).replaceFirst(EnumChatFormatting.ITALIC + item.func_82833_r() + EnumChatFormatting.RESET, this.func_77653_i(item)));
            if (!item.func_82837_s()) {
                par3List.add("Unspecified Frequency: You must name this upgrade in an anvil to choose a frequency");
                par3List.add("You cannot use this upgrade until it has a frequency");
            } else {
                par3List.add("Frequency: " + item.func_82833_r());
                String s = XUHelper.getPlayerOwner(item);
                if (s.equals("")) {
                    par3List.add("Public Spectrum");
                } else {
                    par3List.add("Private Spectrum - " + s);
                }
            }
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!par2World.field_72995_K) {
            switch (par1ItemStack.func_77960_j()) {
                case 1: {
                    par3EntityPlayer.openGui((Object)ExtraUtilsMod.instance, 1, par2World, par3EntityPlayer.field_71071_by.field_70461_c, 0, 0);
                    break;
                }
                case 5: 
                case 6: {
                    if (XUHelper.getPlayerOwner(par1ItemStack).equals("")) {
                        par3EntityPlayer.func_146105_b((IChatComponent)new ChatComponentText("Spectrum set to private"));
                        XUHelper.setPlayerOwner(par1ItemStack, par3EntityPlayer.func_146103_bH().getName());
                        break;
                    }
                    par3EntityPlayer.func_146105_b((IChatComponent)new ChatComponentText("Spectrum set to public"));
                    XUHelper.setPlayerOwner(par1ItemStack, "");
                }
            }
        }
        return par1ItemStack;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + "." + par1ItemStack.func_77960_j();
    }

    @Override
    public String getSortingName(ItemStack item) {
        if (item.func_77960_j() == 1) {
            return item.func_82833_r();
        }
        ItemStack i = item.func_77946_l();
        i.func_77964_b(-1);
        return i.func_82833_r() + item.func_82833_r();
    }
}

