/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.block;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsProxy;
import com.rwtema.extrautils.tileentity.TileEntityEnchantedSpike;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSpike
extends Block {
    public static final Field experienceField = ReflectionHelper.findField(EntityLiving.class, (String[])new String[]{"experienceValue", "field_70728_aV"});
    protected IIcon ironIcon;
    public final ItemStack swordStack;
    public Item itemSpike;

    public BlockSpike() {
        this(Material.field_151573_f, new ItemStack(Items.field_151040_l));
    }

    public BlockSpike(ItemStack swordStack) {
        this(Material.field_151573_f, swordStack);
    }

    public BlockSpike(Material material, ItemStack swordStack) {
        super(material);
        this.func_149663_c("extrautils:spike_base");
        this.func_149658_d("extrautils:spike_base");
        this.func_149711_c(5.0f);
        this.func_149752_b(500.0f);
        this.func_149647_a(ExtraUtils.creativeTabExtraUtils);
        this.func_149672_a(Block.field_149777_j);
        this.swordStack = swordStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IIconRegister) {
        super.func_149651_a(par1IIconRegister);
        this.ironIcon = par1IIconRegister.func_94245_a("extrautils:spike_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        int side = par2 % 6;
        if (par1 == Facing.field_71588_a[side]) {
            return this.field_149761_L;
        }
        return this.ironIcon;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ExtraUtilsProxy.spikeBlockID;
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        int meta = par5 % 6;
        int flag = 0;
        ForgeDirection side = ForgeDirection.getOrientation((int)meta);
        if (!par1World.isSideSolid(par2 - side.offsetX, par3 - side.offsetY, par4 - side.offsetZ, side.getOpposite())) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (side == dir) continue;
                if (par1World.isSideSolid(par2 - dir.offsetX, par3 - dir.offsetY, par4 - dir.offsetZ, dir.getOpposite())) {
                    return flag + dir.ordinal();
                }
                if (par1World.func_147439_a(par2 - dir.offsetX, par3 - dir.offsetY, par4 - dir.offsetZ) != this) continue;
                par5 = par1World.func_72805_g(par2 - dir.offsetX, par3 - dir.offsetY, par4 - dir.offsetZ) % 6;
            }
        }
        return flag + par5;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            ArrayList<ItemStack> items = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            if (world.func_147468_f(x, y, z)) {
                if (!world.field_72995_K) {
                    for (ItemStack item : items) {
                        this.func_149642_a(world, x, y, z, item);
                    }
                }
                return true;
            }
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        par2EntityPlayer.func_71064_a(StatList.field_75934_C[BlockSpike.func_149682_b((Block)this)], 1);
        par2EntityPlayer.func_71020_j(0.025f);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0).get(0);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0).get(0);
    }

    protected ItemStack func_149644_j(int p_149644_1_) {
        return new ItemStack(this.itemSpike, 1, 0);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
        ItemStack stack = new ItemStack(item, 1, this.func_149692_a(metadata));
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityEnchantedSpike) {
            stack.func_77982_d(((TileEntityEnchantedSpike)tile).getEnchantmentTagList());
        }
        ret.add(stack);
        return ret;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        NBTTagList enchantments = stack.func_77986_q();
        if (enchantments != null) {
            int newmeta = 6 + world.func_72805_g(x, y, z) % 6;
            world.func_147465_d(x, y, z, (Block)this, newmeta, 2);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileEntityEnchantedSpike) {
                ((TileEntityEnchantedSpike)tile).setEnchantmentTagList(enchantments);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        double h = 0.0625;
        int side = par1World.func_72805_g(par2, par3, par4) % 6;
        switch (side) {
            case 0: {
                return AxisAlignedBB.func_72330_a((double)((double)par2 + h), (double)((double)par3 + h), (double)((double)par4 + h), (double)((double)par2 + 1.0 - h), (double)((double)par3 + 1.0), (double)((double)par4 + 1.0 - h));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)((double)par2 + h), (double)par3, (double)((double)par4 + h), (double)((double)par2 + 1.0 - h), (double)((double)par3 + 1.0 - h), (double)((double)par4 + 1.0 - h));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)((double)par2 + h), (double)((double)par3 + h), (double)((double)par4 + h), (double)((double)par2 + 1.0 - h), (double)((double)par3 + 1.0 - h), (double)((double)par4 + 1.0));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)((double)par2 + h), (double)((double)par3 + h), (double)par4, (double)((double)par2 + 1.0 - h), (double)((double)par3 + 1.0 - h), (double)((double)par4 + 1.0 - h));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)((double)par2 + h), (double)((double)par3 + h), (double)((double)par4 + h), (double)((double)par2 + 1.0), (double)((double)par3 + 1.0 - h), (double)((double)par4 + 1.0 - h));
            }
            case 5: {
                return AxisAlignedBB.func_72330_a((double)par2, (double)((double)par3 + h), (double)((double)par4 + h), (double)((double)par2 + 1.0 - h), (double)((double)par3 + 1.0 - h), (double)((double)par4 + 1.0 - h));
            }
        }
        return AxisAlignedBB.func_72330_a((double)((double)par2 + h), (double)((double)par3 + h), (double)((double)par4 + h), (double)((double)par2 + 1.0 - h), (double)((double)par3 + 1.0 - h), (double)((double)par4 + 1.0 - h));
    }

    public void func_149670_a(World world, int x, int y, int z, Entity target) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        FakePlayer fakeplayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        float damage = this.getDamageMultipliers(4.0f, tile, (EntityLivingBase)target);
        float h = ((EntityLivingBase)target).func_110143_aJ();
        boolean flag = h > damage || target instanceof EntityPlayer ? target.func_70097_a(DamageSource.field_76367_g, damage - 0.001f) : (world.field_73012_v.nextInt(5) == 0 ? this.doPlayerLastHit((World)((WorldServer)world), target, tile) : target.func_70097_a(DamageSource.field_76367_g, 400.0f));
        if (flag) {
            this.doPostAttack(world, target, tile, x, y, z);
            if (target instanceof EntityLiving) {
                try {
                    experienceField.setInt(target, 0);
                }
                catch (IllegalAccessException ignore) {
                    // empty catch block
                }
            }
        }
    }

    public void doPostAttack(World world, Entity target, TileEntity tile, int x, int y, int z) {
        int j;
        if (!(tile instanceof TileEntityEnchantedSpike)) {
            return;
        }
        ItemStack stack = this.swordStack.func_77946_l();
        stack.func_77982_d(((TileEntityEnchantedSpike)tile).getEnchantmentTagList());
        int i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)stack);
        if (i > 0) {
            int m = world.func_72805_g(x, y, z) % 6;
            float dx = Facing.field_71586_b[m];
            float dz = Facing.field_71585_d[m];
            target.func_70024_g((double)(-dx * (float)i * 0.5f), 0.1, (double)(-dz * (float)i * 0.5f));
        }
        if ((j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)stack)) > 0) {
            target.func_70015_d(j * 4);
        }
    }

    public Item getSwordItem() {
        return Items.field_151040_l;
    }

    public float getDamageMultipliers(float f, TileEntity tile, EntityLivingBase target) {
        if (!(tile instanceof TileEntityEnchantedSpike)) {
            return f;
        }
        ItemStack swordStack = new ItemStack(this.getSwordItem(), 1, 0);
        swordStack.func_77982_d(((TileEntityEnchantedSpike)tile).getEnchantmentTagList());
        float f1 = EnchantmentHelper.func_152377_a((ItemStack)swordStack, (EnumCreatureAttribute)target.func_70668_bt());
        if (f1 > 0.0f) {
            f += f1;
        }
        return f;
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        if (par7Entity instanceof EntityItem) {
            AxisAlignedBB axisalignedbb1 = AxisAlignedBB.func_72330_a((double)par2, (double)par3, (double)par4, (double)(par2 + 1), (double)(par3 + 1), (double)(par4 + 1));
            if (axisalignedbb1 != null && par5AxisAlignedBB.func_72326_a(axisalignedbb1)) {
                par6List.add(axisalignedbb1);
            }
        } else {
            super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.func_72805_g(x, y, z) % 6 == side.getOpposite().ordinal();
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) % 6 == 1 || super.canPlaceTorchOnTop(world, x, y, z);
    }

    public boolean hasTileEntity(int metadata) {
        return metadata >= 6;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityEnchantedSpike();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPlayerLastHit(World world, Entity target, TileEntity tile) {
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        try {
            ItemStack stack = this.swordStack.func_77946_l();
            if (tile instanceof TileEntityEnchantedSpike) {
                stack.func_77982_d(((TileEntityEnchantedSpike)tile).getEnchantmentTagList());
            }
            fakePlayer.func_70062_b(0, stack);
            boolean b = target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)fakePlayer), 400.0f);
            fakePlayer.func_70062_b(0, null);
            b = target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)fakePlayer), 400.0f) | b;
            boolean bl = b = target.func_70097_a(DamageSource.field_76367_g, 400.0f) | b;
            return bl;
        }
        finally {
            fakePlayer.func_70062_b(0, null);
        }
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return this.itemSpike;
    }

    public static class DamageSourceSpike
    extends EntityDamageSource {
        public DamageSourceSpike(String p_i1567_1_, Entity p_i1567_2_) {
            super(p_i1567_1_, p_i1567_2_);
        }
    }
}

