/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.BlockColor;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ThaumcraftHelper {
    public static final int[] pi = new int[]{3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, 8, 9, 7, 9, 3, 2, 3, 8, 4, 6, 2, 6, 4, 3, 3, 8, 3, 2, 7, 9, 5};

    public static void registerItems() {
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            ThaumcraftHelper.registerItems_do();
        }
    }

    private static void registerItems_do() {
        ThaumcraftHelper.addAspectsDivSigil();
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.unstableIngot, Aspect.METAL, 4, Aspect.ELDRITCH, 4, Aspect.ENERGY, 16);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.cursedEarth, Aspect.EARTH, 1, Aspect.DARKNESS, 1, Aspect.UNDEAD, 4, Aspect.ELDRITCH, 1, Aspect.EXCHANGE, 1);
        ThaumcraftHelper.addAspectRecipe((Block)ExtraUtils.enderLily, Aspect.DARKNESS, 1, Items.field_151014_N, Items.field_151079_bi, Aspect.ELDRITCH, 16);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.transferPipe, new int[]{0, 1, 2, 3, 4, 5, 6, 7}, Aspect.TRAVEL, 1, Aspect.ORDER, 1, Aspect.EARTH, 1);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.buildersWand, Aspect.TOOL, 4, Blocks.field_150343_Z, Aspect.ELDRITCH, 4);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.buildersWand, Short.MAX_VALUE, Aspect.TOOL, 4, Blocks.field_150343_Z, Aspect.ELDRITCH, 4, Items.field_151156_bN);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.trashCan, Aspect.VOID, 8, Blocks.field_150347_e, Aspect.ENTROPY, 4);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 8), null, Aspect.MAGIC, 16, Aspect.METAL, 4, Aspect.GREED, 4, Aspect.MIND, 8, Aspect.TREE, 8);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 11), null, Aspect.ELDRITCH, 16);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.spike.itemSpike, -1, null, Aspect.WEAPON, 18, Aspect.METAL, 14);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.spikeDiamond.itemSpike, -1, null, Aspect.WEAPON, 18, Aspect.METAL, 14);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.spikeGold.itemSpike, -1, null, Aspect.WEAPON, 18, Aspect.METAL, 14);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.spikeWood.itemSpike, -1, null, Aspect.WEAPON, 18, Aspect.METAL, 14);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.wateringCan, -1, new ItemStack((Item)ExtraUtils.wateringCan, 1, 1), Aspect.WATER, 1, Aspect.LIFE, 1, Aspect.EARTH, 2);
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.conveyor, -1, null, Blocks.field_150448_aq, Aspect.TRAVEL, 4);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 4), Blocks.field_150417_aV);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 7), Blocks.field_150417_aV);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 0), Blocks.field_150417_aV);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 1), Blocks.field_150343_Z, Items.field_151079_bi);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 2), Blocks.field_150371_ca, Aspect.FIRE, 4);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 3), Blocks.field_150348_b, Blocks.field_150432_aD);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 6), Blocks.field_150351_n);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 10), Blocks.field_150351_n, Blocks.field_150351_n, Aspect.TRAVEL, 1);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 9), Blocks.field_150354_m, Blocks.field_150359_w);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 13), Blocks.field_150354_m, Blocks.field_150377_bs);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 14), Blocks.field_150417_aV, Aspect.SENSES, 2, Aspect.ELDRITCH, 2);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative2, 1, 10), Aspect.CRYSTAL, 2, Aspect.DARKNESS, 4);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative2, 1, 0), Aspect.CRYSTAL, 2);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative2, 1, 3), Aspect.CRYSTAL, 2, Aspect.ENTROPY, 1);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative2, 1, 3), Aspect.CRYSTAL, 2, Aspect.ENTROPY, 1);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative2, 1, 4), Aspect.CRYSTAL, 2, Aspect.GREED, 1);
        ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)ExtraUtils.decorative2, 1, 8), Aspect.CRYSTAL, 2, Aspect.LIFE, 1, Aspect.HEAL, 1);
        for (BlockColor colorblock : ExtraUtils.colorblocks) {
            AspectList aspectList = new AspectList(new ItemStack(colorblock.baseBlock, 1));
            if (aspectList.visSize() <= 0) continue;
            for (int i = 0; i < 16; ++i) {
                ThaumcraftHelper.addAspectRecipe(new ItemStack((Block)colorblock, 1, i), aspectList, Aspect.SENSES, 1);
            }
        }
        ThaumcraftHelper.addAspectRecipe(ExtraUtils.lawSword, Aspect.WEAPON, 64, Aspect.LIFE, 32, Aspect.MAGIC, 16);
    }

    public static void handleQEDRecipes(ArrayList<ItemStack> items) {
        ThaumcraftHelper.handleQEDRecipes_do(items);
    }

    private static void handleQEDRecipes_do(ArrayList<ItemStack> items) {
        for (ItemStack item : items) {
            ThaumcraftApiHelper.getObjectAspects((ItemStack)item);
        }
    }

    private static void addAspectsDivSigil() {
        if (ExtraUtils.divisionSigil == null) {
            return;
        }
        ArrayList<Aspect> a = new ArrayList<Aspect>();
        a.add(Aspect.AURA);
        a.add(Aspect.EXCHANGE);
        a.add(Aspect.TOOL);
        a.add(Aspect.CRAFT);
        a.add(Aspect.ELDRITCH);
        a.add(Aspect.SOUL);
        Collections.sort(a, new Comparator<Aspect>(){

            @Override
            public int compare(Aspect o1, Aspect o2) {
                return o1.getTag().compareTo(o2.getTag());
            }
        });
        AspectList b = new AspectList();
        for (int i = 0; i < a.size(); ++i) {
            b.add((Aspect)a.get(i), pi[i]);
        }
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(ExtraUtils.divisionSigil, 1, Short.MAX_VALUE), (AspectList)b);
    }

    private static void addAspectRecipe(Block block, Object ... ingredients) {
        ThaumcraftHelper.addAspectRecipe(new ItemStack(block), ingredients);
    }

    private static void addAspectRecipe(Item item, Object ... ingredients) {
        ThaumcraftHelper.addAspectRecipe(new ItemStack(item), ingredients);
    }

    private static void addAspectRecipe(ItemStack result, Object ... ingredients) {
        if (result == null) {
            return;
        }
        int[] meta = null;
        AspectList al = new AspectList(result);
        for (int i = 0; i < ingredients.length; ++i) {
            Object o = ingredients[i];
            if (o == null) {
                al.add(new AspectList(result));
                continue;
            }
            if (i == 0 && o instanceof Integer) {
                int newmeta = (Integer)o;
                if (newmeta == -1) {
                    newmeta = Short.MAX_VALUE;
                }
                result.func_77964_b(newmeta);
                continue;
            }
            if (o instanceof int[]) {
                meta = (int[])o;
                continue;
            }
            if (o instanceof AspectList) {
                al.add((AspectList)o);
                continue;
            }
            if (o instanceof Aspect) {
                Aspect a = (Aspect)o;
                int a_num = 1;
                if (i + 1 < ingredients.length && ingredients[i + 1] instanceof Integer) {
                    a_num = (Integer)ingredients[i + 1];
                    ++i;
                }
                al.add(a, a_num);
                continue;
            }
            if (o instanceof ItemStack) {
                AspectList aspectList = new AspectList((ItemStack)o);
                al.add(aspectList);
                continue;
            }
            if (o instanceof Item) {
                AspectList aspectList = new AspectList(new ItemStack((Item)o));
                al.add(aspectList);
                continue;
            }
            if (o instanceof Block) {
                AspectList aspectList = new AspectList(new ItemStack((Block)o));
                al.add(aspectList);
                continue;
            }
            if (!(o instanceof String)) continue;
            AspectList aspectList = new AspectList();
            for (ItemStack itemStack : OreDictionary.getOres((String)((String)o))) {
                aspectList.merge(new AspectList(itemStack));
            }
            al.add(aspectList);
        }
        if (meta != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)result, meta, (AspectList)al);
        } else {
            ThaumcraftApi.registerObjectTag((ItemStack)result, (AspectList)al);
        }
    }
}

