/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.reference.ReferenceMaterial;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemEnderSword
extends ItemSword
implements IKeyBound,
IModular {
    private float damageVsEntity;
    private final Item.ToolMaterial material = ReferenceMaterial.Tool.ENDER_ALLOY_ADVANCED;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconEmpty;
    @SideOnly(value=Side.CLIENT)
    String[] parts;

    public ItemEnderSword() {
        super(ReferenceMaterial.Tool.ENDER_ALLOY_ADVANCED);
        this.func_77625_d(1);
        this.func_77656_e(this.material.func_77997_a());
        this.setNoRepair();
        this.damageVsEntity = 6.0f + this.material.func_78000_c();
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.func_77655_b(ReferenceNames.getPrefixedName("endersword"));
        this.func_111206_d(ReferenceTextures.getItemTextureName("endersword"));
    }

    public float func_150931_i() {
        return this.damageVsEntity;
    }

    public int getMaxDamage(ItemStack stack) {
        return 5;
    }

    public boolean isToolBroken(ItemStack stack) {
        return stack == null || stack.func_77960_j() >= this.getMaxDamage(stack);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = block.func_149688_o();
        if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
            return 1.5f;
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        if (!this.isToolBroken(stack)) {
            stack.func_77972_a(1, living1);
            if (this.isToolBroken(stack)) {
                living1.func_70669_a(stack);
            }
            return true;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase livingbase) {
        if (block.func_149712_f(world, x, y, z) != 0.0f && !this.isToolBroken(stack)) {
            int amount = Math.min(2, this.getMaxDamage(stack) - stack.func_77960_j());
            stack.func_77972_a(amount, livingbase);
            if (this.isToolBroken(stack)) {
                livingbase.func_70669_a(stack);
            }
            return true;
        }
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_77995_e();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150321_G;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        double dmg = this.damageVsEntity;
        if (this.isToolBroken(stack)) {
            dmg = 1.0;
        }
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", dmg, 0));
        return multimap;
    }

    private byte getToolMode(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        return nbt.func_74771_c("ToolMode");
    }

    public void toggleToolMode(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        byte mode = this.getToolMode(stack);
        if ((mode = (byte)(mode + 1)) > 2) {
            mode = 0;
        }
        nbt.func_74774_a("ToolMode", mode);
        stack.func_77982_d(nbt);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null) {
            return;
        }
        if (ReferenceKeys.getBaseKey(key) == 1) {
            this.toggleToolMode(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = EnderUtilities.proxy.isShiftKeyDown();
        if (stack != null && stack.func_77978_p() == null) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 1) {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.holdshiftfordescription"));
            } else {
                list.addAll(tmpList);
            }
        }
        super.func_77624_a(stack, player, list, advancedTooltips);
    }

    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderUtilities.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.parts = new String[]{"rod", "head.1", "head.2", "head.3", "head.1.broken", "head.2.broken", "head.3.broken", "core.1", "core.2", "core.3", "capacitor.1", "capacitor.2", "capacitor.3", "linkcrystal.1", "linkcrystal.2"};
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".rod");
        this.iconEmpty = iconRegister.func_94245_a(ReferenceTextures.getItemTextureName("empty"));
        this.iconArray = new IIcon[this.parts.length];
        String prefix = this.func_111208_A() + ".";
        for (int i = 0; i < this.parts.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(prefix + this.parts[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack == null) {
            return this.field_77791_bV;
        }
        int i = 0;
        int tier = 0;
        switch (renderPass) {
            case 0: {
                break;
            }
            case 1: {
                i += this.getToolMode(stack) + 1;
                if (!this.isToolBroken(stack)) break;
                i += 3;
                break;
            }
            case 2: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE);
                if (tier > 0) {
                    i += tier + 6;
                    break;
                }
                return this.iconEmpty;
            }
            case 3: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
                if (tier > 0) {
                    i += tier + 9;
                    break;
                }
                return this.iconEmpty;
            }
            case 4: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                if (tier > 0) {
                    i += tier + 12;
                    break;
                }
                return this.iconEmpty;
            }
            default: {
                return this.iconEmpty;
            }
        }
        if (i < 0 || i >= this.iconArray.length) {
            return this.iconEmpty;
        }
        return this.iconArray[i];
    }

    @Override
    public int getModuleCount(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getModuleCount(stack, moduleType);
    }

    @Override
    public int getMaxModules(ItemStack stack) {
        return 3;
    }

    @Override
    public int getMaxModules(ItemStack stack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack toolStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 0 || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(toolStack, moduleType);
        }
        return 0;
    }

    @Override
    public int getMaxModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getMaxModuleTier(stack, moduleType);
    }

    @Override
    public int getSelectedModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleTier(stack, moduleType);
    }

    @Override
    public ItemStack getSelectedModuleStack(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleStack(stack, moduleType);
    }

    @Override
    public ItemStack setSelectedModuleStack(ItemStack toolStack, ItemModule.ModuleType moduleType, ItemStack moduleStack) {
        return UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
    }

    @Override
    public ItemStack changeSelectedModule(ItemStack stack, ItemModule.ModuleType moduleType, boolean reverse) {
        return stack;
    }

    @Override
    public List<NBTTagCompound> getAllModules(ItemStack stack) {
        return UtilItemModular.getAllModules(stack);
    }

    @Override
    public ItemStack setAllModules(ItemStack stack, List<NBTTagCompound> modules) {
        return UtilItemModular.setAllModules(stack, modules);
    }

    @Override
    public ItemStack setModule(ItemStack stack, int index, NBTTagCompound nbt) {
        return UtilItemModular.setModule(stack, index, nbt);
    }
}

