/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiTextureProgressBar;

public class BeefGuiHeatBar
extends BeefGuiTextureProgressBar
implements IBeefTooltipControl {
    private float heatMax = 2000.0f;
    private float heat = 0.0f;
    private String[] tooltip;

    public BeefGuiHeatBar(BeefGuiBase container, int x, int y, String tooltipTitle, String[] tooltipExtra) {
        super(container, x, y);
        if (tooltipExtra == null) {
            this.tooltip = new String[3];
        } else {
            this.tooltip = new String[3 + tooltipExtra.length];
            for (int i = 0; i < tooltipExtra.length; ++i) {
                this.tooltip[i + 3] = tooltipExtra[i];
            }
        }
        this.tooltip[0] = tooltipTitle;
        this.tooltip[1] = "";
        this.tooltip[2] = "";
    }

    public void setHeat(float newHeat) {
        this.heat = newHeat;
        this.tooltip[1] = String.format("  %.0f C", Float.valueOf(newHeat));
    }

    @Override
    protected String getBackgroundTexture() {
        return "controls/HeatBar.png";
    }

    @Override
    protected float getProgress() {
        return Math.min(1.0f, Math.max(0.0f, this.heat / this.heatMax));
    }

    @Override
    public String[] getTooltip() {
        return this.tooltip;
    }
}

