/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import java.util.Arrays;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Centrifuge")
@ModOnly(value={"gregtech"})
public class Centrifuge {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, int cells, int durationTicks) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError("centrifuge must have at least 1 output");
        } else {
            MineTweakerAPI.apply(new AddRecipeAction(outputs, input, cells, durationTicks));
        }
    }

    @ZenMethod
    public static void addRecipeFuelCan(IItemStack[] outputs, IItemStack input, int duration) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError("centrifuge must have at least 1 output");
        } else {
            MineTweakerAPI.apply(new AddRecipeAction(outputs, input, -1, duration));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final IItemStack input;
        private final int cells;
        private final int duration;

        public AddRecipeAction(IItemStack[] output, IItemStack input, int cells, int duration) {
            this.output = output;
            this.input = input;
            this.cells = cells;
            this.duration = duration;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addCentrifugeRecipe(MineTweakerMC.getItemStack(this.input), this.cells, MineTweakerMC.getItemStack(this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack(this.output[1]) : null, this.output.length > 2 ? MineTweakerMC.getItemStack(this.output[2]) : null, this.output.length > 3 ? MineTweakerMC.getItemStack(this.output[3]) : null, this.output.length > 4 ? MineTweakerMC.getItemStack(this.output[4]) : null, this.output.length > 5 ? MineTweakerMC.getItemStack(this.output[5]) : null, this.duration);
        }

        @Override
        public String describe() {
            return "Adding centrifuge recipe with input " + this.input;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Arrays.deepHashCode(this.output);
            hash = 59 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 59 * hash + this.cells;
            hash = 59 * hash + this.duration;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)obj;
            if (!Arrays.deepEquals(this.output, other.output)) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.cells != other.cells) {
                return false;
            }
            return this.duration == other.duration;
        }
    }
}

