/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.registries;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.ENBlocks;
import exnihilo.blocks.ores.BlockOre;
import exnihilo.blocks.ores.BlockOreFactory;
import exnihilo.compatibility.ThermalExpansion;
import exnihilo.compatibility.TinkersConstruct;
import exnihilo.items.ores.ItemOre;
import exnihilo.items.ores.ItemOreFactory;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class OreRegistry {
    public static List<String> ores = new ArrayList<String>();
    public static Hashtable<String, BlockOre> gravelTable = new Hashtable();
    public static Hashtable<String, BlockOre> sandTable = new Hashtable();
    public static Hashtable<String, BlockOre> dustTable = new Hashtable();
    public static Hashtable<String, ItemOre> brokenTable = new Hashtable();
    public static Hashtable<String, ItemOre> crushedTable = new Hashtable();
    public static Hashtable<String, ItemOre> powderedTable = new Hashtable();
    public static Hashtable<String, ItemOre> ingotTable = new Hashtable();

    private static void registerOreBlock(String name, BlockOre block, Hashtable<String, BlockOre> table) {
        if (!table.containsValue((Object)block)) {
            table.put(name.toLowerCase(), block);
            GameRegistry.registerBlock((Block)block, (String)block.getName());
            if (Loader.isModLoaded((String)"ThermalExpansion")) {
                ThermalExpansion.TryRegisterOre(name, (Block)block);
            }
            if (Loader.isModLoaded((String)"TConstruct")) {
                TinkersConstruct.TryRegisterOre(name, (Block)block);
            }
        }
    }

    private static void registerOreItem(String name, ItemOre item, Hashtable<String, ItemOre> table) {
        String lname = name.toLowerCase();
        if (!table.containsValue((Object)item)) {
            table.put(lname, item);
            GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        }
    }

    public static void createOverworldOre(String name, Color color, int rarity) {
        OreRegistry.createOverworldOre(name, color, rarity, null, false);
    }

    public static void createOverworldOre(String name, Color color, int rarity, Item ingot) {
        OreRegistry.createOverworldOre(name, color, rarity, ingot, false);
    }

    public static void createOverworldOre(String name, Color color, int rarity, boolean skipFurnaceRecipes) {
        OreRegistry.createOverworldOre(name, color, rarity, null, skipFurnaceRecipes);
    }

    public static void createOverworldOre(String name, Color color, int rarity, Item existingIngot, boolean skipFurnaceRecipes) {
        OreRegistry.createOre(0, name, color, rarity, existingIngot, skipFurnaceRecipes);
    }

    public static void createNetherOre(String name, Color color, int rarity) {
        OreRegistry.createNetherOre(name, color, rarity, null, false);
    }

    public static void createNetherOre(String name, Color color, int rarity, Item ingot) {
        OreRegistry.createNetherOre(name, color, rarity, ingot, false);
    }

    public static void createNetherOre(String name, Color color, int rarity, boolean skipFurnaceRecipes) {
        OreRegistry.createNetherOre(name, color, rarity, null, skipFurnaceRecipes);
    }

    public static void createNetherOre(String name, Color color, int rarity, Item existingIngot, boolean skipFurnaceRecipes) {
        OreRegistry.createOre(-1, name, color, rarity, existingIngot, skipFurnaceRecipes);
    }

    public static void createEnderOre(String name, Color color, int rarity) {
        OreRegistry.createEnderOre(name, color, rarity, null, false);
    }

    public static void createEnderOre(String name, Color color, int rarity, Item ingot) {
        OreRegistry.createEnderOre(name, color, rarity, ingot, false);
    }

    public static void createEnderOre(String name, Color color, int rarity, boolean skipFurnaceRecipes) {
        OreRegistry.createEnderOre(name, color, rarity, null, skipFurnaceRecipes);
    }

    public static void createEnderOre(String name, Color color, int rarity, Item existingIngot, boolean skipFurnaceRecipes) {
        OreRegistry.createOre(1, name, color, rarity, existingIngot, skipFurnaceRecipes);
    }

    private static void createOre(int type, String name, Color color, int rarity, Item existingIngot, boolean skipFurnaceRecipes) {
        Item ingot;
        ItemOre powdered;
        BlockOre dust;
        if (ores.contains(type + "_" + name.toLowerCase())) {
            return;
        }
        ores.add(type + "_" + name.toLowerCase());
        BlockOre gravel = null;
        boolean gravelAlreadyExisted = false;
        switch (type) {
            case -1: {
                gravel = gravelTable.get("nether_" + name);
                if (gravel == null) {
                    gravel = BlockOreFactory.MakeNetherGravel(name, color);
                    OreRegistry.registerOreBlock("nether_" + name, gravel, gravelTable);
                    break;
                }
                gravelAlreadyExisted = true;
                break;
            }
            case 0: {
                gravel = gravelTable.get(name);
                if (gravel == null) {
                    gravel = BlockOreFactory.MakeOverworldGravel(name, color);
                    OreRegistry.registerOreBlock(name, gravel, gravelTable);
                    break;
                }
                gravelAlreadyExisted = true;
                break;
            }
            case 1: {
                gravel = gravelTable.get("ender_" + name);
                if (gravel == null) {
                    gravel = BlockOreFactory.MakeEnderGravel(name, color);
                    OreRegistry.registerOreBlock("ender_" + name, gravel, gravelTable);
                    break;
                }
                gravelAlreadyExisted = true;
            }
        }
        BlockOre sand = sandTable.get(name);
        if (sand == null) {
            sand = BlockOreFactory.MakeSand(name, color);
            OreRegistry.registerOreBlock(name, sand, sandTable);
        }
        if ((dust = dustTable.get(name)) == null) {
            dust = BlockOreFactory.MakeDust(name, color);
            OreRegistry.registerOreBlock(name, dust, dustTable);
        }
        ItemOre broken = null;
        switch (type) {
            case -1: {
                broken = brokenTable.get("nether_" + name);
                if (broken != null) break;
                broken = ItemOreFactory.MakeNetherBrokenOre(name, color);
                OreRegistry.registerOreItem("nether_" + name, broken, brokenTable);
                break;
            }
            case 0: {
                broken = brokenTable.get(name);
                if (broken != null) break;
                broken = ItemOreFactory.MakeOverworldBrokenOre(name, color);
                OreRegistry.registerOreItem(name, broken, brokenTable);
                break;
            }
            case 1: {
                broken = brokenTable.get("ender_" + name);
                if (broken != null) break;
                broken = ItemOreFactory.MakeEnderBrokenOre(name, color);
                OreRegistry.registerOreItem("ender_" + name, broken, brokenTable);
            }
        }
        ItemOre crushed = crushedTable.get(name);
        if (crushed == null) {
            crushed = ItemOreFactory.MakeCrushedOre(name, color);
            OreRegistry.registerOreItem(name, crushed, crushedTable);
        }
        if ((powdered = powderedTable.get(name)) == null) {
            powdered = ItemOreFactory.MakePulverizedOre(name, color);
            OreRegistry.registerOreItem(name, powdered, powderedTable);
        }
        if (existingIngot != null) {
            ingot = existingIngot;
        } else {
            ingot = ingotTable.get(name);
            if (ingot == null) {
                ItemOre newIngot = ItemOreFactory.MakeIngot(name, color);
                OreRegistry.registerOreItem(name, newIngot, ingotTable);
                ingot = newIngot;
                OreRegistry.registerOreDict(name, ingot);
            }
        }
        ArrayList ores = OreDictionary.getOres((String)("ore" + OreRegistry.formatOreName(name)));
        if (type == 0 && ores.size() > 0) {
            for (ItemStack i : ores) {
                if (Block.func_149634_a((Item)i.func_77973_b()) == Blocks.field_150350_a) continue;
                OreRegistry.registerHammerRecipe(Block.func_149634_a((Item)i.func_77973_b()), i.func_77960_j(), broken);
            }
        }
        if (!gravelAlreadyExisted) {
            OreRegistry.registerHammerRecipe((Block)gravel, crushed);
        }
        if (!HammerRegistry.registered((Block)sand, 0)) {
            OreRegistry.registerHammerRecipe((Block)sand, powdered);
        }
        OreRegistry.registerCraftingRecipe(broken, gravel);
        OreRegistry.registerCraftingRecipe(crushed, sand);
        OreRegistry.registerCraftingRecipe(powdered, dust);
        if (!skipFurnaceRecipes) {
            OreRegistry.registerFurnaceRecipe(gravel, ingot);
            OreRegistry.registerFurnaceRecipe(sand, ingot);
            OreRegistry.registerFurnaceRecipe(dust, ingot);
        }
        switch (type) {
            case -1: {
                OreRegistry.registerSieveRecipe(ENBlocks.NetherGravel, broken, rarity);
                break;
            }
            case 0: {
                OreRegistry.registerSieveRecipe(Blocks.field_150351_n, broken, rarity);
                OreRegistry.registerSieveRecipe((Block)Blocks.field_150354_m, crushed, rarity);
                OreRegistry.registerSieveRecipe(ENBlocks.Dust, powdered, rarity);
                break;
            }
            case 1: {
                OreRegistry.registerSieveRecipe(ENBlocks.EnderGravel, broken, rarity);
            }
        }
    }

    public static void registerOreDict(String name, Item ingot) {
        OreDictionary.registerOre((String)("ingot" + OreRegistry.formatOreName(name)), (Item)ingot);
    }

    private static void registerHammerRecipe(Block block, ItemOre reward) {
        HammerRegistry.registerOre(block, 0, reward, 0);
    }

    private static void registerHammerRecipe(Block block, int meta, ItemOre reward) {
        HammerRegistry.registerOre(block, meta, reward, 0);
    }

    private static void registerCraftingRecipe(ItemOre ingredient, BlockOre result) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)result, 1, 0), new Object[]{"xx", "xx", Character.valueOf('x'), ingredient}));
    }

    private static void registerFurnaceRecipe(BlockOre ore, Item ingot) {
        FurnaceRecipes.func_77602_a().func_151393_a((Block)ore, new ItemStack(ingot, 1, 0), 0.1f);
    }

    private static void registerSieveRecipe(Block block, ItemOre item, int rarity) {
        SieveRegistry.register(block, item, 0, rarity);
    }

    private static String formatOreName(String input) {
        String lcase = input.toLowerCase();
        String output = lcase.substring(0, 1).toUpperCase() + lcase.substring(1);
        return output;
    }

    public static Block getGravel(String name) {
        return (Block)gravelTable.get(name.toLowerCase());
    }

    public static Block getSand(String name) {
        return (Block)sandTable.get(name.toLowerCase());
    }

    public static Block getDust(String name) {
        return (Block)dustTable.get(name.toLowerCase());
    }

    public static Item getBroken(String name) {
        return brokenTable.get(name.toLowerCase());
    }

    public static Item getCrushed(String name) {
        return crushedTable.get(name.toLowerCase());
    }

    public static Item getPowdered(String name) {
        return powderedTable.get(name.toLowerCase());
    }

    public static Item getIngot(String name) {
        return ingotTable.get(name.toLowerCase());
    }
}

