/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.rftools.RFTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class SpawnerConfiguration {
    public static final String CATEGORY_SPAWNER = "spawner";
    public static final String CATEGORY_MOBSPAWNAMOUNTS = "mobspawnamounts";
    public static final String CATEGORY_MOBSPAWNRF = "mobspawnrf";
    public static final String CATEGORY_LIVINGMATTER = "livingmatter";
    public static final Map<String, Integer> mobSpawnRf = new HashMap<String, Integer>();
    public static final Map<String, List<MobSpawnAmount>> mobSpawnAmounts = new HashMap<String, List<MobSpawnAmount>>();
    public static final Map<Object, Float> livingMatter = new HashMap<Object, Float>();
    public static final int MATERIALTYPE_KEY = 0;
    public static final int MATERIALTYPE_BULK = 1;
    public static final int MATERIALTYPE_LIVING = 2;
    public static int SPAWNER_MAXENERGY = 200000;
    public static int SPAWNER_RECEIVEPERTICK = 2000;
    public static int BEAMER_MAXENERGY = 200000;
    public static int BEAMER_RECEIVEPERTICK = 1000;
    public static int beamRfPerObject = 2000;
    public static int beamBlocksPerSend = 1;
    public static int maxBeamDistance = 8;
    public static int maxMatterStorage = 6400;

    public static void init(Configuration cfg) {
        SPAWNER_MAXENERGY = cfg.get(CATEGORY_SPAWNER, "spawnerMaxRF", SPAWNER_MAXENERGY, "Maximum RF storage that the spawner can hold").getInt();
        SPAWNER_RECEIVEPERTICK = cfg.get(CATEGORY_SPAWNER, "spawnerRFPerTick", SPAWNER_RECEIVEPERTICK, "RF per tick that the spawner can receive").getInt();
        BEAMER_MAXENERGY = cfg.get(CATEGORY_SPAWNER, "beamerMaxRF", BEAMER_MAXENERGY, "Maximum RF storage that the matter beamer can hold").getInt();
        BEAMER_RECEIVEPERTICK = cfg.get(CATEGORY_SPAWNER, "beamerRFPerTick", BEAMER_RECEIVEPERTICK, "RF per tick that the matter beamer can receive").getInt();
        beamRfPerObject = cfg.get(CATEGORY_SPAWNER, "beamerRfPerSend", beamRfPerObject, "RF per tick that the matter beamer will use for sending over a single object").getInt();
        beamBlocksPerSend = cfg.get(CATEGORY_SPAWNER, "beamerBlocksPerSend", beamBlocksPerSend, "The amount of blocks that the matter beamer will use send in one operation (every 20 ticks)").getInt();
        maxMatterStorage = cfg.get(CATEGORY_SPAWNER, "spawnerMaxMatterStorage", maxMatterStorage, "The maximum amount of energized matter that this spawner can store (per type)").getInt();
        maxBeamDistance = cfg.get(CATEGORY_SPAWNER, "maxBeamDistance", maxBeamDistance, "The maximum distance that a laser can travel between the beamer and the spawner").getInt();
        SpawnerConfiguration.readLivingConfig(cfg);
    }

    public static void readLivingConfig(Configuration cfg) {
        ConfigCategory category = cfg.getCategory(CATEGORY_LIVINGMATTER);
        if (category.isEmpty()) {
            SpawnerConfiguration.setupInitialLivingConfig(cfg);
        } else {
            for (Map.Entry entry : category.entrySet()) {
                String[] value = ((Property)entry.getValue()).getStringList();
                try {
                    String type = value[0];
                    String name = value[1];
                    Float factor = Float.valueOf(Float.parseFloat(value[2]));
                    if ("B".equals(type)) {
                        Object block = Block.field_149771_c.func_82594_a(name);
                        livingMatter.put(block, factor);
                        continue;
                    }
                    Object item = Item.field_150901_e.func_82594_a(name);
                    livingMatter.put(item, factor);
                }
                catch (Exception e) {
                    RFTools.logError("Badly formatted 'livingmatter' configuration option!");
                    return;
                }
            }
        }
    }

    private static void setupInitialLivingConfig(Configuration cfg) {
        int counter = 0;
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.field_150362_t, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.field_150361_u, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.field_150345_g, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.field_150407_cf, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.field_150440_ba, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.field_150434_aF, counter, 0.8f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151034_e, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151015_O, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151014_N, counter, 0.8f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151174_bG, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151172_bF, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151080_bb, counter, 0.8f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151081_bc, counter, 0.8f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151082_bd, counter, 2.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151147_al, counter, 2.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.field_151076_bf, counter, 2.0f);
    }

    private static int addLiving(Configuration cfg, Block block, int counter, float factor) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        cfg.get(CATEGORY_LIVINGMATTER, "living." + counter, new String[]{"B", name, Float.toString(factor)});
        livingMatter.put(block, Float.valueOf(factor));
        return counter + 1;
    }

    private static int addLiving(Configuration cfg, Item item, int counter, float factor) {
        String name = Item.field_150901_e.func_148750_c((Object)item);
        cfg.get(CATEGORY_LIVINGMATTER, "living." + counter, new String[]{"I", name, Float.toString(factor)});
        livingMatter.put(item, Float.valueOf(factor));
        return counter + 1;
    }

    public static void readMobSpawnAmountConfig(Configuration cfg) {
        SpawnerConfiguration.addMobSpawnRF(cfg, "Bat", 100);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Bat", 0, Items.field_151008_G, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Bat", 1, Blocks.field_150346_d, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Bat", 2, null, 0, 2.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Blaze", 1000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Blaze", 0, Items.field_151072_bj, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Blaze", 1, Blocks.field_150424_aL, 0, 60.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Blaze", 2, null, 0, 9.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Cave Spider", 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Cave Spider", 0, Items.field_151007_F, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Cave Spider", 1, Blocks.field_150346_d, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Cave Spider", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Chicken", 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Chicken", 0, Items.field_151008_G, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Chicken", 1, Blocks.field_150346_d, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Chicken", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Cow", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Cow", 0, Items.field_151116_aA, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Cow", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Cow", 2, null, 0, 8.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Creeper", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Creeper", 0, Items.field_151016_H, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Creeper", 1, Blocks.field_150346_d, 0, 60.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Creeper", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Dragon", 100000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Dragon", 0, Items.field_151062_by, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Dragon", 1, Blocks.field_150377_bs, 0, 200.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Dragon", 2, null, 0, 200.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Enderman", 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Enderman", 0, Items.field_151079_bi, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Enderman", 1, Blocks.field_150377_bs, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Enderman", 2, null, 0, 11.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Ghast", 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Ghast", 0, Items.field_151073_bk, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Ghast", 1, Blocks.field_150424_aL, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Ghast", 2, null, 0, 12.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Horse", 1000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Horse", 0, Items.field_151116_aA, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Horse", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Horse", 2, null, 0, 8.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Iron Golem", 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Iron Golem", 0, Items.field_151042_j, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Iron Golem", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Iron Golem", 2, 38, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Magma Cube", 600);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Magma Cube", 0, Items.field_151064_bs, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Magma Cube", 1, Blocks.field_150424_aL, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Magma Cube", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Mooshroom", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Mooshroom", 0, Items.field_151116_aA, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Mooshroom", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Mooshroom", 2, null, 0, 8.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Ocelot", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Ocelot", 0, Items.field_151115_aP, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Ocelot", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Ocelot", 2, null, 0, 8.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Pig", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Pig", 0, Items.field_151116_aA, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Pig", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Pig", 2, null, 0, 8.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Sheep", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Sheep", 0, Blocks.field_150325_L, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Sheep", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Sheep", 2, null, 0, 8.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Skeleton", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Skeleton", 0, Items.field_151103_aS, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Skeleton", 1, Blocks.field_150346_d, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Skeleton", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Slime", 600);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Slime", 0, Items.field_151123_aH, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Slime", 1, Blocks.field_150346_d, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Slime", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Snowman", 600);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Snowman", 0, Items.field_151126_ay, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Snowman", 1, Blocks.field_150346_d, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Snowman", 2, null, 0, 4.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Spider", 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Spider", 0, Items.field_151007_F, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Spider", 1, Blocks.field_150346_d, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Spider", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Squid", 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Squid", 0, 351, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Squid", 1, Blocks.field_150346_d, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Squid", 2, null, 0, 4.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Villager", 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Villager", 0, Items.field_151122_aG, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Villager", 1, Blocks.field_150346_d, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Villager", 2, null, 0, 7.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Witch", 1200);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Witch", 0, Items.field_151069_bo, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Witch", 1, Blocks.field_150346_d, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Witch", 2, null, 0, 7.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Wither", 20000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wither", 0, Items.field_151156_bN, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wither", 1, Blocks.field_150425_aM, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wither", 2, null, 0, 6.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Wolf", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wolf", 0, Items.field_151103_aS, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wolf", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wolf", 2, null, 0, 8.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Zombie Pigman", 1200);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Zombie Pigman", 0, Items.field_151074_bl, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Zombie Pigman", 1, Blocks.field_150424_aL, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Zombie Pigman", 2, null, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Zombie", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Zombie", 0, Items.field_151078_bh, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Zombie", 1, Blocks.field_150346_d, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Zombie", 2, null, 0, 5.0f);
    }

    public static void readModdedMobSpawnAmountConfig(Configuration cfg) {
        SpawnerConfiguration.addMobSpawnRF(cfg, "Blizz", 1000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Blizz", 0, Items.field_151126_ay, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Blizz", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Blizz", 2, null, 0, 9.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "Wisp", 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wisp", 0, Items.field_151045_i, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wisp", 1, Blocks.field_150346_d, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "Wisp", 2, null, 0, 4.0f);
    }

    public static void addMobSpawnRF(Configuration cfg, String name, int rf) {
        rf = cfg.get(CATEGORY_MOBSPAWNRF, name, rf).getInt();
        mobSpawnRf.put(name, rf);
    }

    public static void addMobSpawnAmount(Configuration cfg, String name, int materialType, Object object, int meta, float amount) {
        String itemname;
        String type;
        if (object instanceof Item) {
            type = "I";
            itemname = Item.field_150901_e.func_148750_c(object);
        } else if (object instanceof Block) {
            type = "B";
            itemname = Block.field_149771_c.func_148750_c(object);
        } else if (object instanceof String) {
            type = "S";
            itemname = (String)object;
        } else if (object instanceof Integer) {
            Integer id = (Integer)object;
            type = id < 0 ? "B" : "I";
            itemname = Integer.toString(id);
        } else {
            type = "L";
            itemname = "";
        }
        String[] splitted = cfg.get(CATEGORY_MOBSPAWNAMOUNTS, name + ".spawnamount." + materialType, new String[]{type, itemname, Integer.toString(meta), Float.toString(amount)}).getStringList();
        try {
            type = splitted[0];
            itemname = splitted[1];
            meta = Integer.parseInt(splitted[2]);
            amount = Float.parseFloat(splitted[3]);
        }
        catch (NumberFormatException e) {
            RFTools.logError("Something went wrong parsing the spawnamount setting for '" + name + "'!");
            return;
        }
        ItemStack stack = null;
        if ("I".equals(type)) {
            Item item;
            try {
                Integer id = Integer.parseInt(itemname);
                item = (Item)Item.field_150901_e.func_148754_a(id.intValue());
            }
            catch (NumberFormatException e) {
                item = (Item)Item.field_150901_e.func_82594_a(itemname);
            }
            stack = new ItemStack(item, 1, meta);
        } else if ("B".equals(type)) {
            Block block;
            try {
                Integer id = Integer.parseInt(itemname);
                block = (Block)Block.field_149771_c.func_148754_a(id.intValue());
            }
            catch (NumberFormatException e) {
                block = (Block)Block.field_149771_c.func_82594_a(itemname);
            }
            stack = new ItemStack(block, 1, meta);
        } else if ("S".equals(type)) {
            // empty if block
        }
        List<MobSpawnAmount> list = mobSpawnAmounts.get(name);
        if (list == null) {
            list = new ArrayList<MobSpawnAmount>(3);
            list.add(null);
            list.add(null);
            list.add(null);
            mobSpawnAmounts.put(name, list);
        }
        list.set(materialType, new MobSpawnAmount(stack, amount));
    }

    public static class MobSpawnAmount {
        private final ItemStack object;
        private final float amount;

        public MobSpawnAmount(ItemStack object, float amount) {
            this.object = object;
            this.amount = amount;
        }

        public ItemStack getObject() {
            return this.object;
        }

        public float getAmount() {
            return this.amount;
        }

        public Float match(ItemStack stack) {
            if (this.object == null) {
                Item item = stack.func_77973_b();
                if (item instanceof ItemBlock) {
                    Block block = ((ItemBlock)item).field_150939_a;
                    return livingMatter.get(block);
                }
                return livingMatter.get(item);
            }
            if (stack.func_77969_a(this.object)) {
                return Float.valueOf(1.0f);
            }
            return null;
        }
    }
}

