/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.item.TEItems;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SawmillManager {
    private static Map<ComparableItemStackSawmill, RecipeSawmill> recipeMap = new THashMap();
    private static ComparableItemStackSawmill query = new ComparableItemStackSawmill(new ItemStack(Blocks.field_150348_b));
    private static boolean allowOverwrite = false;
    private static float logMultiplier = 1.5f;

    public static RecipeSawmill getRecipe(ItemStack itemStack) {
        return itemStack == null ? null : recipeMap.get((Object)query.set(itemStack));
    }

    public static boolean recipeExists(ItemStack itemStack) {
        return SawmillManager.getRecipe(itemStack) != null;
    }

    public static RecipeSawmill[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeSawmill[0]);
    }

    public static void addDefaultRecipes() {
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150323_B), new ItemStack(Blocks.field_150344_f, 8), new ItemStack(Items.field_151137_ax, 1));
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151104_aV), new ItemStack(Blocks.field_150344_f, 3), new ItemStack(Blocks.field_150325_L, 3));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150342_X), new ItemStack(Blocks.field_150344_f, 6), new ItemStack(Items.field_151122_aG, 3));
        SawmillManager.addRecipe(2400, new ItemStack((Block)Blocks.field_150486_ae), new ItemStack(Blocks.field_150344_f, 8));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150462_ai), new ItemStack(Blocks.field_150344_f, 4));
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151155_ap), new ItemStack(Blocks.field_150344_f, 2));
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151135_aq), new ItemStack(Blocks.field_150344_f, 6));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150452_aw), new ItemStack(Blocks.field_150344_f, 2));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150421_aI), new ItemStack(Blocks.field_150344_f, 8), new ItemStack(Items.field_151045_i, 1));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150415_aT), new ItemStack(Blocks.field_150344_f, 3));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150396_be), new ItemStack(Blocks.field_150344_f, 2), TEItems.sawdust);
        SawmillManager.addRecipe(800, new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151127_ba, 8));
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151124_az), new ItemStack(Blocks.field_150344_f, 5));
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151041_m), new ItemStack(Blocks.field_150344_f, 2), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151038_n), new ItemStack(Blocks.field_150344_f, 1), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151039_o), new ItemStack(Blocks.field_150344_f, 3), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151053_p), new ItemStack(Blocks.field_150344_f, 3), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151017_I), new ItemStack(Blocks.field_150344_f, 2), TEItems.sawdust);
    }

    public static void loadRecipes() {
        SawmillManager.addAllLogs();
        if (ItemHelper.oreNameExists((String)"woodRubber")) {
            if (ItemHelper.oreNameExists((String)"itemRawRubber")) {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Blocks.field_150344_f, 5, 3), (ItemStack)OreDictionary.getOres((String)"itemRawRubber").get(0), 50);
            } else if (ItemHelper.oreNameExists((String)"itemRubber")) {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Blocks.field_150344_f, 5, 3), (ItemStack)OreDictionary.getOres((String)"itemRubber").get(0), 50);
            } else {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Blocks.field_150344_f, 5, 3));
            }
        }
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackSawmill, RecipeSawmill> entry : recipeMap.entrySet()) {
            RecipeSawmill recipeSawmill = entry.getValue();
            tHashMap.put(new ComparableItemStackSawmill(recipeSawmill.input), recipeSawmill);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeSawmill recipeSawmill = new RecipeSawmill(itemStack, itemStack2, itemStack3, n2, n);
        recipeMap.put(new ComparableItemStackSawmill(itemStack), recipeSawmill);
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && SawmillManager.recipeExists(itemStack)) {
            return false;
        }
        RecipeSawmill recipeSawmill = new RecipeSawmill(itemStack, itemStack2, itemStack3, n2, n);
        recipeMap.put(new ComparableItemStackSawmill(itemStack), recipeSawmill);
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack) {
        return recipeMap.remove((Object)new ComparableItemStackSawmill(itemStack)) != null;
    }

    public static void addAllLogs() {
        Container container = new Container(){

            public boolean func_75145_c(EntityPlayer entityPlayer) {
                return false;
            }
        };
        InventoryCrafting inventoryCrafting = new InventoryCrafting(container, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inventoryCrafting.func_70299_a(i, null);
        }
        ArrayList arrayList = OreDictionary.getOres((String)"logWood");
        for (int i = 0; i < arrayList.size(); ++i) {
            ItemStack itemStack;
            ItemStack itemStack2;
            ItemStack itemStack3 = (ItemStack)arrayList.get(i);
            if (ItemHelper.getItemDamage((ItemStack)itemStack3) == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    itemStack2 = ItemHelper.cloneStack((ItemStack)itemStack3, (int)1);
                    itemStack2.func_77964_b(j);
                    inventoryCrafting.func_70299_a(0, itemStack2);
                    itemStack = ItemHelper.findMatchingRecipe((InventoryCrafting)inventoryCrafting, null);
                    if (itemStack == null) continue;
                    ItemStack itemStack4 = itemStack.func_77946_l();
                    itemStack4.field_77994_a = (int)((float)itemStack4.field_77994_a * logMultiplier);
                    SawmillManager.addRecipe(800, itemStack2, itemStack4, TEItems.sawdust);
                }
                continue;
            }
            ItemStack itemStack5 = ItemHelper.cloneStack((ItemStack)itemStack3, (int)1);
            inventoryCrafting.func_70299_a(0, itemStack5);
            itemStack2 = ItemHelper.findMatchingRecipe((InventoryCrafting)inventoryCrafting, null);
            if (itemStack2 == null) continue;
            itemStack = itemStack2.func_77946_l();
            itemStack.field_77994_a = (int)((float)itemStack.field_77994_a * logMultiplier);
            SawmillManager.addRecipe(800, itemStack5, itemStack, TEItems.sawdust);
        }
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        return SawmillManager.addTERecipe(n, itemStack, itemStack2, null, 0);
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return SawmillManager.addTERecipe(n, itemStack, itemStack2, itemStack3, 100);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, null, 0, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, boolean bl) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, 100, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, n2, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Sawmill", "AllowRecipeOverwrite", false);
        String string = "RecipeManagers.Sawmill.Log";
        String string2 = "This sets the default rate for Log->Plank conversion. This number is used in all automatically generated recipes.";
        logMultiplier = MathHelper.clampF((float)((float)ThermalExpansion.config.get(string, "DefaultMultiplier", (double)logMultiplier, string2)), (float)1.0f, (float)64.0f);
    }

    public static class ComparableItemStackSawmill
    extends ComparableItemStack {
        static final String ORE = "ore";
        static final String INGOT = "ingot";
        static final String NUGGET = "nugget";
        static final String RUBBER = "woodRubber";

        public static boolean safeOreType(String string) {
            return string.startsWith(ORE) || string.startsWith(INGOT) || string.startsWith(NUGGET) || string.equals(RUBBER);
        }

        public static int getOreID(ItemStack itemStack) {
            int n = ItemHelper.oreProxy.getOreID(itemStack);
            if (n == -1 || !ComparableItemStackSawmill.safeOreType(ItemHelper.oreProxy.getOreName(n))) {
                return -1;
            }
            return n;
        }

        public static int getOreID(String string) {
            if (!ComparableItemStackSawmill.safeOreType(string)) {
                return -1;
            }
            return ItemHelper.oreProxy.getOreID(string);
        }

        public ComparableItemStackSawmill(ItemStack itemStack) {
            super(itemStack);
            this.oreID = ComparableItemStackSawmill.getOreID(itemStack);
        }

        public ComparableItemStackSawmill(Item item, int n, int n2) {
            super(item, n, n2);
            this.oreID = ComparableItemStackSawmill.getOreID(this.toItemStack());
        }

        public ComparableItemStackSawmill set(ItemStack itemStack) {
            super.set(itemStack);
            this.oreID = ComparableItemStackSawmill.getOreID(itemStack);
            return this;
        }
    }

    public static class RecipeSawmill {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeSawmill(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n, int n2) {
            this.input = itemStack;
            this.primaryOutput = itemStack2;
            this.secondaryOutput = itemStack3;
            this.secondaryChance = n;
            this.energy = n2;
            if (itemStack.field_77994_a <= 0) {
                itemStack.field_77994_a = 1;
            }
            if (itemStack2.field_77994_a <= 0) {
                itemStack2.field_77994_a = 1;
            }
            if (itemStack3 != null && itemStack3.field_77994_a <= 0) {
                itemStack3.field_77994_a = 1;
            }
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

