/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui;

import appeng.api.config.RedstoneMode;
import extracells.container.ContainerFluidEmitter;
import extracells.gui.widget.DigitTextField;
import extracells.gui.widget.WidgetRedstoneModes;
import extracells.gui.widget.fluid.WidgetFluidSlot;
import extracells.network.packet.other.IFluidSlotGui;
import extracells.network.packet.part.PacketFluidEmitter;
import extracells.part.PartFluidLevelEmitter;
import extracells.registries.PartEnum;
import extracells.util.GuiUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiFluidEmitter
extends GuiContainer
implements IFluidSlotGui {
    public static final int xSize = 176;
    public static final int ySize = 166;
    private DigitTextField amountField;
    private PartFluidLevelEmitter part;
    private EntityPlayer player;
    private ResourceLocation guiTexture = new ResourceLocation("extracells", "textures/gui/levelemitterfluid.png");
    private WidgetFluidSlot fluidSlot;

    public GuiFluidEmitter(PartFluidLevelEmitter _part, EntityPlayer _player) {
        super((Container)new ContainerFluidEmitter(_part, _player));
        this.player = _player;
        this.part = _part;
        this.fluidSlot = new WidgetFluidSlot(this.player, this.part, 79, 36);
        new PacketFluidEmitter(false, this.part, this.player).sendPacketToServer();
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.modifyAmount(-1);
                break;
            }
            case 1: {
                this.modifyAmount(-10);
                break;
            }
            case 2: {
                this.modifyAmount(-100);
                break;
            }
            case 3: {
                this.modifyAmount(1);
                break;
            }
            case 4: {
                this.modifyAmount(10);
                break;
            }
            case 5: {
                this.modifyAmount(100);
                break;
            }
            case 6: {
                new PacketFluidEmitter(true, this.part, this.player).sendPacketToServer();
            }
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.guiTexture);
        int posX = (this.field_146294_l - 176) / 2;
        int posY = (this.field_146295_m - 166) / 2;
        this.func_73729_b(posX, posY, 0, 0, 176, 166);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(PartEnum.FLUIDLEVELEMITTER.getStatName(), 5, 5, 0);
        this.fluidSlot.drawWidget();
        ((WidgetRedstoneModes)((Object)this.field_146292_n.get(6))).drawTooltip(mouseX, mouseY, (this.field_146294_l - 176) / 2, (this.field_146295_m - 166) / 2);
        GuiUtil.renderOverlay(this.field_73735_i, this.field_147003_i, this.field_147009_r, this.fluidSlot, mouseX, mouseY);
    }

    public void func_73863_a(int x, int y, float f) {
        String[] buttonNames = new String[]{"-1", "-10", "-100", "+1", "+10", "+100"};
        String[] shiftNames = new String[]{"-100", "-1000", "-10000", "+100", "+1000", "+10000"};
        for (int i = 0; i < this.field_146292_n.size() && i != 6; ++i) {
            GuiButton currentButton = (GuiButton)this.field_146292_n.get(i);
            currentButton.field_146126_j = Keyboard.isKeyDown((int)42) ? shiftNames[i] + "mB" : buttonNames[i] + "mB";
        }
        super.func_73863_a(x, y, f);
        this.amountField.func_146194_f();
    }

    public void func_73866_w_() {
        int posX = (this.field_146294_l - 176) / 2;
        int posY = (this.field_146295_m - 166) / 2;
        this.amountField = new DigitTextField(this.field_146289_q, posX + 10, posY + 40, 59, 10);
        this.amountField.func_146195_b(true);
        this.amountField.func_146185_a(false);
        this.amountField.func_146193_g(0xFFFFFF);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, posX + 65 - 46, posY + 8 + 6, 42, 20, "-1"));
        this.field_146292_n.add(new GuiButton(1, posX + 115 - 46, posY + 8 + 6, 42, 20, "-10"));
        this.field_146292_n.add(new GuiButton(2, posX + 165 - 46, posY + 8 + 6, 42, 20, "-100"));
        this.field_146292_n.add(new GuiButton(3, posX + 65 - 46, posY + 58 - 2, 42, 20, "+1"));
        this.field_146292_n.add(new GuiButton(4, posX + 115 - 46, posY + 58 - 2, 42, 20, "+10"));
        this.field_146292_n.add(new GuiButton(5, posX + 165 - 46, posY + 58 - 2, 42, 20, "+100"));
        this.field_146292_n.add(new WidgetRedstoneModes(6, posX + 120, posY + 36, 16, 16, RedstoneMode.LOW_SIGNAL, true));
        super.func_73866_w_();
    }

    protected void func_73869_a(char key, int keyID) {
        super.func_73869_a(key, keyID);
        if ("0123456789".contains(String.valueOf(key)) || keyID == 14) {
            this.amountField.func_146201_a(key, keyID);
            new PacketFluidEmitter(this.amountField.func_146179_b(), this.part, this.player).sendPacketToServer();
        }
    }

    private void modifyAmount(int amount) {
        if (Keyboard.isKeyDown((int)42)) {
            amount *= 100;
        }
        new PacketFluidEmitter(amount, this.part, this.player).sendPacketToServer();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        if (GuiUtil.isPointInRegion(this.field_147003_i, this.field_147009_r, this.fluidSlot.getPosX(), this.fluidSlot.getPosY(), 18, 18, mouseX, mouseY)) {
            this.fluidSlot.mouseClicked(this.player.field_71071_by.func_70445_o());
        }
    }

    public void setAmountField(long amount) {
        this.amountField.func_146180_a(Long.toString(amount));
    }

    public void setRedstoneMode(RedstoneMode mode) {
        ((WidgetRedstoneModes)((Object)this.field_146292_n.get(6))).setRedstoneMode(mode);
    }

    @Override
    public void updateFluids(List<Fluid> _fluids) {
        if (_fluids == null || _fluids.isEmpty()) {
            this.fluidSlot.setFluid(null);
            return;
        }
        this.fluidSlot.setFluid(_fluids.get(0));
    }
}

