/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.network.packet.AbstractServerPacket;
import thaumicenergistics.registries.EnumCache;

public class PacketServerArcaneCraftingTerminal
extends AbstractServerPacket {
    private static final byte MODE_REQUEST_FULL_LIST = 1;
    private static final byte MODE_REQUEST_EXTRACTION = 2;
    private static final byte MODE_REQUEST_DEPOSIT = 3;
    private static final byte MODE_REQUEST_CLEAR_GRID = 4;
    private static final byte MODE_REQUEST_DEPOSIT_REGION = 5;
    private static final byte MODE_REQUEST_SET_SORT = 6;
    private static final byte MODE_REQUEST_SET_GRID = 7;
    private static final byte MODE_REQUEST_AUTO_CRAFT = 8;
    private static final int ITEM_GRID_SIZE = 9;
    private IAEItemStack itemStack;
    private int mouseButton;
    private boolean isShiftHeld;
    private int slotNumber;
    private SortOrder sortingOrder;
    private SortDir sortingDirection;
    private ViewItems viewMode;
    private IAEItemStack[] gridItems;

    public PacketServerArcaneCraftingTerminal createNEIRequestSetCraftingGrid(EntityPlayer player, IAEItemStack[] items) {
        this.player = player;
        this.mode = (byte)7;
        this.gridItems = items;
        return this;
    }

    public PacketServerArcaneCraftingTerminal createRequestAutoCraft(EntityPlayer player, IAEItemStack result) {
        this.player = player;
        this.mode = (byte)8;
        this.itemStack = result;
        return this;
    }

    public PacketServerArcaneCraftingTerminal createRequestClearGrid(EntityPlayer player) {
        this.player = player;
        this.mode = (byte)4;
        return this;
    }

    public PacketServerArcaneCraftingTerminal createRequestDeposit(EntityPlayer player, int mouseButton) {
        this.player = player;
        this.mode = (byte)3;
        this.mouseButton = mouseButton;
        return this;
    }

    public PacketServerArcaneCraftingTerminal createRequestDepositRegion(EntityPlayer player, int slotNumber) {
        this.player = player;
        this.mode = (byte)5;
        this.slotNumber = slotNumber;
        return this;
    }

    public PacketServerArcaneCraftingTerminal createRequestExtract(EntityPlayer player, IAEItemStack itemStack, int mouseButton, boolean isShiftHeld) {
        this.player = player;
        this.mode = (byte)2;
        this.itemStack = itemStack;
        this.mouseButton = mouseButton;
        this.isShiftHeld = isShiftHeld;
        return this;
    }

    public PacketServerArcaneCraftingTerminal createRequestFullList(EntityPlayer player) {
        this.player = player;
        this.mode = 1;
        return this;
    }

    public PacketServerArcaneCraftingTerminal createRequestSetSort(EntityPlayer player, SortOrder order, SortDir direction, ViewItems viewMode) {
        this.player = player;
        this.mode = (byte)6;
        this.sortingDirection = direction;
        this.sortingOrder = order;
        this.viewMode = viewMode;
        return this;
    }

    @Override
    public void execute() {
        if (this.player != null && this.player.field_71070_bA instanceof ContainerPartArcaneCraftingTerminal) {
            switch (this.mode) {
                case 1: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientRequestFullUpdate(this.player);
                    break;
                }
                case 2: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientRequestExtract(this.player, this.itemStack, this.mouseButton, this.isShiftHeld);
                    break;
                }
                case 3: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientRequestDeposit(this.player, this.mouseButton);
                    break;
                }
                case 4: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientRequestClearCraftingGrid(this.player);
                    break;
                }
                case 5: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientRequestDepositRegion(this.player, this.slotNumber);
                    break;
                }
                case 6: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientRequestSetSort(this.sortingOrder, this.sortingDirection, this.viewMode);
                    break;
                }
                case 7: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientNEIRequestSetCraftingGrid(this.player, this.gridItems);
                    break;
                }
                case 8: {
                    ((ContainerPartArcaneCraftingTerminal)this.player.field_71070_bA).onClientRequestAutoCraft(this.player, this.itemStack);
                }
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 2: {
                this.itemStack = AbstractPacket.readAEItemStack(stream);
                this.mouseButton = stream.readInt();
                this.isShiftHeld = stream.readBoolean();
                break;
            }
            case 3: {
                this.mouseButton = stream.readInt();
                break;
            }
            case 5: {
                this.slotNumber = stream.readInt();
                break;
            }
            case 6: {
                this.sortingDirection = EnumCache.AE_SORT_DIRECTIONS[stream.readInt()];
                this.sortingOrder = EnumCache.AE_SORT_ORDERS[stream.readInt()];
                this.viewMode = EnumCache.AE_VIEW_ITEMS[stream.readInt()];
                break;
            }
            case 7: {
                this.gridItems = new IAEItemStack[9];
                for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                    if (!stream.readBoolean()) continue;
                    this.gridItems[slotIndex] = AbstractPacket.readAEItemStack(stream);
                }
                break;
            }
            case 8: {
                this.itemStack = AbstractPacket.readAEItemStack(stream);
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 2: {
                AbstractPacket.writeAEItemStack(this.itemStack, stream);
                stream.writeInt(this.mouseButton);
                stream.writeBoolean(this.isShiftHeld);
                break;
            }
            case 3: {
                stream.writeInt(this.mouseButton);
                break;
            }
            case 5: {
                stream.writeInt(this.slotNumber);
                break;
            }
            case 6: {
                stream.writeInt(this.sortingDirection.ordinal());
                stream.writeInt(this.sortingOrder.ordinal());
                stream.writeInt(this.viewMode.ordinal());
                break;
            }
            case 7: {
                for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
                    IAEItemStack slotItem = this.gridItems[slotIndex];
                    boolean hasItem = slotItem != null;
                    stream.writeBoolean(hasItem);
                    if (!hasItem) continue;
                    AbstractPacket.writeAEItemStack(slotItem, stream);
                }
                break;
            }
            case 8: {
                AbstractPacket.writeAEItemStack(this.itemStack, stream);
            }
        }
    }
}

