/*
 * Decompiled with CFR 0.152.
 */
package cofh.api.modhelpers;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModAPIManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ThaumcraftHelper {
    private static Map<String, ? extends Object> aspects = null;
    private static Method registerItem = null;
    private static Method registerEntity = null;
    private static Class<?> AspectList = null;
    private static Constructor<?> newAspectList = null;
    private static Method addAspect = null;
    private static boolean works = false;

    private ThaumcraftHelper() {
    }

    private static void parseAspects(Object object, String string) throws Throwable {
        if (!works) {
            return;
        }
        if (!(string = string.trim()).isEmpty()) {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i].trim().split(" ", 2);
                if (stringArray2.length != 2) {
                    FMLLog.bigWarning((String)"[CoFH Thaumcraft Helper] Invalid aspect entry '%s'", (Object[])new Object[]{stringArray[i]});
                    continue;
                }
                String string2 = stringArray2[1].trim();
                if (aspects.containsKey(string2)) {
                    addAspect.invoke(object, aspects.get(string2), Integer.valueOf(stringArray2[0], 10));
                    continue;
                }
                FMLLog.fine((String)"[CoFH Thaumcraft Helper] %s aspect missing.", (Object[])new Object[]{stringArray2[1]});
            }
        }
    }

    public static void parseAspects(String string, String string2) throws Throwable {
        if (!works) {
            return;
        }
        Object obj = AspectList.newInstance();
        ThaumcraftHelper.parseAspects(obj, string2);
        registerEntity.invoke(null, string, obj, null);
    }

    public static void parseAspects(ItemStack itemStack, String string, boolean bl) throws Throwable {
        if (!works) {
            return;
        }
        Object obj = bl ? newAspectList.newInstance(itemStack) : AspectList.newInstance();
        ThaumcraftHelper.parseAspects(obj, string);
        registerItem.invoke(null, itemStack, obj);
    }

    public static void parseAspects(ItemStack itemStack, String string) throws Throwable {
        ThaumcraftHelper.parseAspects(itemStack, string, true);
    }

    public static void parseAspects(Item item, int n, String string, boolean bl) throws Throwable {
        ThaumcraftHelper.parseAspects(new ItemStack(item, 1, n), string, bl);
    }

    public static void parseAspects(Item item, String string, boolean bl) throws Throwable {
        ThaumcraftHelper.parseAspects(item, Short.MAX_VALUE, string, bl);
    }

    public static void parseAspects(Item item, int n, String string) throws Throwable {
        ThaumcraftHelper.parseAspects(item, n, string, true);
    }

    public static void parseAspects(Item item, String string) throws Throwable {
        ThaumcraftHelper.parseAspects(item, Short.MAX_VALUE, string, true);
    }

    public static void parseAspects(Block block, int n, String string, boolean bl) throws Throwable {
        ThaumcraftHelper.parseAspects(new ItemStack(block, 1, n), string, bl);
    }

    public static void parseAspects(Block block, String string, boolean bl) throws Throwable {
        ThaumcraftHelper.parseAspects(block, Short.MAX_VALUE, string, bl);
    }

    public static void parseAspects(Block block, int n, String string) throws Throwable {
        ThaumcraftHelper.parseAspects(block, n, string, true);
    }

    public static void parseAspects(Block block, String string) throws Throwable {
        ThaumcraftHelper.parseAspects(block, Short.MAX_VALUE, string, true);
    }

    static {
        try {
            if (ModAPIManager.INSTANCE.hasAPI("Thaumcraft|API")) {
                Class<?> clazz = Class.forName("thaumcraft.api.aspects.Aspect");
                aspects = (Map)clazz.getDeclaredField("aspects").get(null);
                Class<?> clazz2 = Class.forName("thaumcraft.api.ThaumcraftApi");
                AspectList = Class.forName("thaumcraft.api.aspects.AspectList");
                registerItem = clazz2.getDeclaredMethod("registerObjectTag", ItemStack.class, AspectList);
                Class<?> clazz3 = Class.forName("[Lthaumcraft.api.ThaumcraftApi$EntityTagsNBT;");
                registerEntity = clazz2.getDeclaredMethod("registerEntityTag", String.class, AspectList, clazz3);
                addAspect = AspectList.getDeclaredMethod("add", clazz, Integer.TYPE);
                newAspectList = AspectList.getDeclaredConstructor(ItemStack.class);
                works = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

