/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield.filters;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shield.filters.AnimalFilter;
import mcjty.rftools.blocks.shield.filters.DefaultFilter;
import mcjty.rftools.blocks.shield.filters.HostileFilter;
import mcjty.rftools.blocks.shield.filters.ItemFilter;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractShieldFilter
implements ShieldFilter {
    private int action = 0;

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public void setAction(int action) {
        this.action = action;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBT(tagCompound);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tagCompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.action = tagCompound.func_74762_e("action");
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("type", this.getFilterName());
        tagCompound.func_74768_a("action", this.action);
    }

    public static ShieldFilter createFilter(ByteBuf buf) {
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        return AbstractShieldFilter.createFilter(compound);
    }

    public static ShieldFilter createFilter(NBTTagCompound compound) {
        String type = compound.func_74779_i("type");
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.readFromNBT(compound);
        return filter;
    }

    public static ShieldFilter createFilter(String type) {
        AbstractShieldFilter filter;
        if ("animal".equals(type)) {
            filter = new AnimalFilter();
        } else if ("hostile".equals(type)) {
            filter = new HostileFilter();
        } else if ("player".equals(type)) {
            filter = new PlayerFilter();
        } else if ("item".equals(type)) {
            filter = new ItemFilter();
        } else if ("default".equals(type)) {
            filter = new DefaultFilter();
        } else {
            RFTools.log("Unknown filter type = " + type);
            filter = new DefaultFilter();
        }
        return filter;
    }
}

