/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.network.PacketReturnScreenData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketGetScreenData
implements IMessage,
IMessageHandler<PacketGetScreenData, PacketReturnScreenData> {
    private int x;
    private int y;
    private int z;
    private long millis;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.millis = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeLong(this.millis);
    }

    public PacketGetScreenData() {
    }

    public PacketGetScreenData(int tileX, int tileY, int tileZ, long millis) {
        this.x = tileX;
        this.y = tileY;
        this.z = tileZ;
        this.millis = millis;
    }

    public PacketReturnScreenData onMessage(PacketGetScreenData message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        TileEntity te = world.func_147438_o(message.x, message.y, message.z);
        if (!(te instanceof ScreenTileEntity)) {
            System.out.println("PacketGetScreenData: TileEntity is not a SimpleScreenTileEntity!");
            return null;
        }
        Map<Integer, Object[]> screenData = ((ScreenTileEntity)te).getScreenData(message.millis);
        return new PacketReturnScreenData(message.x, message.y, message.z, screenData);
    }
}

