/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class BucketFillHandler {
    public static final BucketFillHandler instance = new BucketFillHandler();
    private final Set<Class<? extends IFluidHandler>> whitelist = Sets.newHashSet();

    private BucketFillHandler() {
    }

    public void addToWhitelist(Class<? extends TileEntity> cls) {
        this.whitelist.add(cls);
    }

    private boolean shouldFill(Object target) {
        if (!(target instanceof IFluidHandler)) {
            return false;
        }
        return this.whitelist.contains(target.getClass());
    }

    private static ItemStack fillTank(IFluidHandler handler, ForgeDirection dir, ItemStack container) {
        FluidTankInfo[] tanks;
        for (FluidTankInfo tank : tanks = handler.getTankInfo(dir)) {
            FluidStack drained;
            ItemStack filledStack;
            FluidStack filled;
            FluidStack available = tank.fluid;
            if (available == null || available.amount <= 0 || (filled = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filledStack = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)container)))) == null || !filled.isFluidEqual(available) || filled.amount > available.amount || !(drained = handler.drain(dir, filled.amount, false)).isFluidStackIdentical(filled)) continue;
            handler.drain(dir, filled.amount, true);
            return filledStack;
        }
        return null;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent evt) {
        ItemStack result;
        MovingObjectPosition target = evt.target;
        if (target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        TileEntity te = evt.world.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (this.shouldFill(te) && (result = BucketFillHandler.fillTank((IFluidHandler)te, ForgeDirection.getOrientation((int)target.field_72310_e), evt.current)) != null) {
            evt.result = result;
            evt.setResult(Event.Result.ALLOW);
        }
    }
}

