/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.gui.overlay;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.util.ArrayList;
import mapwriter.api.IMwChunkOverlay;
import mapwriter.api.IMwDataProvider;
import mapwriter.map.MapView;
import mapwriter.map.mapmode.MapMode;
import mcp.mobius.opis.api.IMessageHandler;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesChunk;
import mcp.mobius.opis.data.holders.basetypes.SerialInt;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntity;
import mcp.mobius.opis.data.managers.ChunkManager;
import mcp.mobius.opis.gui.events.MouseEvent;
import mcp.mobius.opis.gui.interfaces.CType;
import mcp.mobius.opis.gui.interfaces.IWidget;
import mcp.mobius.opis.gui.interfaces.WAlign;
import mcp.mobius.opis.gui.widgets.LayoutBase;
import mcp.mobius.opis.gui.widgets.LayoutCanvas;
import mcp.mobius.opis.gui.widgets.WidgetGeometry;
import mcp.mobius.opis.gui.widgets.tableview.TableRow;
import mcp.mobius.opis.gui.widgets.tableview.ViewTable;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.client.PacketReqChunks;
import mcp.mobius.opis.network.packets.client.PacketReqData;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public enum OverlayMeanTime implements IMwDataProvider,
IMessageHandler
{
    INSTANCE;

    CoordinatesChunk selectedChunk = null;
    public boolean showList = false;
    public LayoutCanvas canvas = null;

    @Override
    public ArrayList<IMwChunkOverlay> getChunksOverlay(int dim, double centerX, double centerZ, double minX, double minZ, double maxX, double maxZ) {
        ArrayList<IMwChunkOverlay> overlays = new ArrayList<IMwChunkOverlay>();
        double minTime = 9999.0;
        double maxTime = 0.0;
        for (CoordinatesChunk chunk : ChunkManager.INSTANCE.getChunkMeanTime().keySet()) {
            minTime = Math.min(minTime, ChunkManager.INSTANCE.getChunkMeanTime().get(chunk).getDataSum());
            maxTime = Math.max(maxTime, ChunkManager.INSTANCE.getChunkMeanTime().get(chunk).getDataSum());
        }
        for (CoordinatesChunk chunk : ChunkManager.INSTANCE.getChunkMeanTime().keySet()) {
            if (this.selectedChunk != null) {
                overlays.add(new ChunkOverlay(chunk.chunkX, chunk.chunkZ, ChunkManager.INSTANCE.getChunkMeanTime().get((Object)chunk).tileEntities, ChunkManager.INSTANCE.getChunkMeanTime().get(chunk).getDataSum(), minTime, maxTime, chunk.equals(this.selectedChunk)));
                continue;
            }
            overlays.add(new ChunkOverlay(chunk.chunkX, chunk.chunkZ, ChunkManager.INSTANCE.getChunkMeanTime().get((Object)chunk).tileEntities, ChunkManager.INSTANCE.getChunkMeanTime().get(chunk).getDataSum(), minTime, maxTime, false));
        }
        return overlays;
    }

    @Override
    public String getStatusString(int dim, int bX, int bY, int bZ) {
        int xChunk = bX >> 4;
        int zChunk = bZ >> 4;
        CoordinatesChunk chunkCoord = new CoordinatesChunk(dim, xChunk, zChunk);
        if (ChunkManager.INSTANCE.getChunkMeanTime().containsKey(chunkCoord)) {
            if (modOpis.microseconds) {
                return String.format(" | %.3f \u00b5s", ChunkManager.INSTANCE.getChunkMeanTime().get(chunkCoord).getDataSum() / 1000.0);
            }
            return String.format(", %.5f ms", ChunkManager.INSTANCE.getChunkMeanTime().get(chunkCoord).getDataSum() / 1000.0 / 1000.0);
        }
        return "";
    }

    @Override
    public void onMiddleClick(int dim, int bX, int bZ, MapView mapview) {
        this.showList = false;
        int chunkX = bX >> 4;
        int chunkZ = bZ >> 4;
        CoordinatesChunk clickedChunk = new CoordinatesChunk(dim, chunkX, chunkZ);
        this.selectedChunk = ChunkManager.INSTANCE.getChunkMeanTime().containsKey(clickedChunk) ? (this.selectedChunk == null ? clickedChunk : (this.selectedChunk.equals(clickedChunk) ? null : clickedChunk)) : null;
        if (this.selectedChunk != null) {
            PacketManager.sendToServer(new PacketReqData(Message.LIST_CHUNK_TILEENTS, this.selectedChunk));
        }
    }

    public void setSelectedChunk(int dim, int chunkX, int chunkZ) {
        this.selectedChunk = new CoordinatesChunk(dim, chunkX, chunkZ);
        if (this.selectedChunk != null) {
            PacketManager.sendToServer(new PacketReqData(Message.LIST_CHUNK_TILEENTS, this.selectedChunk));
        }
    }

    @Override
    public void onDimensionChanged(int dimension, MapView mapview) {
        PacketManager.sendToServer(new PacketReqData(Message.OVERLAY_CHUNK_TIMING, new SerialInt(dimension)));
    }

    @Override
    public void onMapCenterChanged(double vX, double vZ, MapView mapview) {
    }

    @Override
    public void onZoomChanged(int level, MapView mapview) {
    }

    @Override
    public void onOverlayActivated(MapView mapview) {
        this.selectedChunk = null;
        PacketManager.sendToServer(new PacketReqData(Message.OVERLAY_CHUNK_TIMING, new SerialInt(mapview.getDimension())));
    }

    @Override
    public void onOverlayDeactivated(MapView mapview) {
        this.showList = false;
        this.selectedChunk = null;
        PacketManager.sendToServer(new PacketReqData(Message.COMMAND_UNREGISTER));
    }

    @Override
    public void onDraw(MapView mapview, MapMode mapmode) {
        if (this.canvas == null) {
            this.canvas = new LayoutCanvas();
        }
        if (mapmode.marginLeft != 0) {
            this.canvas.hide();
            return;
        }
        if (!this.showList) {
            this.canvas.hide();
        } else {
            this.canvas.show();
            this.canvas.draw();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupTable(ArrayList<ISerializable> entities) {
        if (this.canvas == null) {
            this.canvas = new LayoutCanvas();
        }
        LayoutBase layout = (LayoutBase)this.canvas.addWidget("Table", new LayoutBase(null));
        layout.setGeometry(new WidgetGeometry(100.0, 0.0, 30.0, 100.0, CType.RELXY, CType.RELXY, WAlign.RIGHT, WAlign.TOP));
        layout.setBackgroundColors(-1876942816, -1876942816);
        EntitiesTable table = (EntitiesTable)layout.addWidget("Table_", new EntitiesTable(null, this));
        table.setGeometry(new WidgetGeometry(0.0, 0.0, 100.0, 100.0, CType.RELXY, CType.RELXY, WAlign.LEFT, WAlign.TOP));
        table.setColumnsAlign(WAlign.CENTER, WAlign.CENTER, WAlign.CENTER).setColumnsTitle("Type", "Pos", "Update Time").setColumnsWidth(50.0, 25.0, 25.0).setRowColors(-8355712, -11513776).setFontSize(1.0f);
        for (ISerializable uncasted : entities) {
            DataBlockTileEntity data = (DataBlockTileEntity)uncasted;
            String name = String.format("te.%d.%d", data.id, data.meta);
            try {
                ItemStack is = new ItemStack(Block.func_149729_e((int)data.id), 1, (int)data.meta);
                name = is.func_82833_r();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (modOpis.microseconds) {
                table.addRow(data, name, String.format("[ %s %s %s ]", data.pos.x, data.pos.y, data.pos.z), data.update.asMillisecond().toString());
                continue;
            }
            table.addRow(data, name, String.format("[ %s %s %s ]", data.pos.x, data.pos.y, data.pos.z), data.update.toString());
        }
        this.showList = true;
    }

    @Override
    public boolean onMouseInput(MapView mapview, MapMode mapmode) {
        if (this.canvas != null && this.canvas.shouldRender() && this.canvas.hasWidgetAtCursor()) {
            ((EntitiesTable)this.canvas.getWidget("Table").getWidget("Table_")).setMap(mapview, mapmode);
            this.canvas.handleMouseInput();
            return true;
        }
        return false;
    }

    private void requestChunkUpdate(int dim, int chunkX, int chunkZ) {
        ArrayList<CoordinatesChunk> chunks = new ArrayList<CoordinatesChunk>();
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                chunks.add(new CoordinatesChunk(dim, chunkX + x, chunkZ + z));
                if (chunks.size() < 1) continue;
                PacketManager.sendToServer(new PacketReqChunks(dim, chunks));
                chunks.clear();
            }
        }
        if (chunks.size() > 0) {
            PacketManager.sendToServer(new PacketReqChunks(dim, chunks));
        }
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_CHUNK_TILEENTS: {
                this.setupTable(rawdata.array);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public class ChunkOverlay
    implements IMwChunkOverlay {
        Point coord;
        int nentities;
        double time;
        double minTime;
        double maxTime;
        boolean selected;

        public ChunkOverlay(int x, int z, int nentities, double time, double mintime, double maxtime, boolean selected) {
            this.coord = new Point(x, z);
            this.nentities = nentities;
            this.time = time;
            this.minTime = mintime;
            this.maxTime = maxtime;
            this.selected = selected;
        }

        @Override
        public Point getCoordinates() {
            return this.coord;
        }

        @Override
        public int getColor() {
            double scaledTime = this.time / this.maxTime;
            int red = MathHelper.func_76143_f((double)(scaledTime * 255.0));
            int blue = 255 - MathHelper.func_76143_f((double)(scaledTime * 255.0));
            return -939524096 + (red << 16) + blue;
        }

        @Override
        public float getFilling() {
            return 1.0f;
        }

        @Override
        public boolean hasBorder() {
            return true;
        }

        @Override
        public float getBorderWidth() {
            return 0.5f;
        }

        @Override
        public int getBorderColor() {
            return this.selected ? -1 : -16777216;
        }
    }

    public class EntitiesTable
    extends ViewTable {
        MapView mapView;
        MapMode mapMode;
        OverlayMeanTime overlay;

        public EntitiesTable(IWidget parent, OverlayMeanTime overlay) {
            super(parent);
            this.overlay = overlay;
        }

        public void setMap(MapView mapView, MapMode mapMode) {
            this.mapView = mapView;
            this.mapMode = mapMode;
        }

        @Override
        public void onMouseClick(MouseEvent event) {
            TableRow row = this.getRow(event.x, event.y);
            if (row != null) {
                CoordinatesBlock coord = ((DataBlockTileEntity)row.getObject()).pos;
                if (this.mapView.getX() != (double)coord.x || this.mapView.getZ() != (double)coord.z) {
                    this.mapView.setViewCentre(coord.x, coord.z);
                    this.overlay.requestChunkUpdate(this.mapView.getDimension(), MathHelper.func_76143_f((double)this.mapView.getX()) >> 4, MathHelper.func_76143_f((double)this.mapView.getZ()) >> 4);
                } else {
                    PacketManager.sendToServer(new PacketReqData(Message.COMMAND_TELEPORT_BLOCK, coord));
                    Minecraft.func_71410_x().func_71381_h();
                }
            }
        }
    }
}

