/*
 * Decompiled with CFR 0.152.
 */
package mantle.blocks.abstracts;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Random;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.debug.DebugHelper;
import mantle.debug.IDebuggable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class InventoryBlock
extends BlockContainer {
    protected Random rand = new Random();
    int side = -1;
    public IIcon[] icons;

    protected InventoryBlock(Material material) {
        super(material);
    }

    public TileEntity createNewTileEntity(World var1) {
        return null;
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    public abstract Integer getGui(World var1, int var2, int var3, int var4, EntityPlayer var5);

    public abstract Object getModInstance();

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        if (player.func_70093_af()) {
            return false;
        }
        Integer integer = this.getGui(world, x, y, z, player);
        if (integer == null || integer == -1) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui(this.getModInstance(), integer.intValue(), world, x, y, z);
        }
        return true;
    }

    public void func_149749_a(World par1World, int x, int y, int z, Block blockID, int meta) {
        TileEntity te = par1World.func_147438_o(x, y, z);
        if (te != null && te instanceof InventoryLogic) {
            InventoryLogic logic = (InventoryLogic)te;
            logic.removeBlock();
            for (int iter = 0; iter < logic.func_70302_i_(); ++iter) {
                ItemStack stack = logic.func_70301_a(iter);
                if (stack == null || !logic.canDropInventorySlot(iter)) continue;
                float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int itemSize = this.rand.nextInt(21) + 10;
                    if (itemSize > stack.field_77994_a) {
                        itemSize = stack.field_77994_a;
                    }
                    stack.field_77994_a -= itemSize;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), new ItemStack(stack.func_77973_b(), itemSize, stack.func_77960_j()));
                    if (stack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    float offset = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * offset;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * offset + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * offset;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(par1World, x, y, z, blockID, meta);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        this.side = side;
        return meta;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity logic = world.func_147438_o(x, y, z);
        if (logic instanceof IFacingLogic) {
            IFacingLogic direction = (IFacingLogic)logic;
            if (this.side != -1) {
                direction.setDirection(this.side);
                this.side = -1;
            }
            if (entityliving == null) {
                direction.setDirection(0.0f, 0.0f, null);
            } else {
                direction.setDirection(entityliving.field_70177_z * 4.0f, entityliving.field_70125_A, entityliving);
            }
        }
        if (logic instanceof InventoryLogic) {
            InventoryLogic inv = (InventoryLogic)logic;
            inv.placeBlock(entityliving, stack);
            if (stack.func_82837_s()) {
                inv.setInvName(stack.func_82833_r());
            }
        }
    }

    public static boolean isActive(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.func_147438_o(x, y, z);
        if (logic instanceof IActiveLogic) {
            return ((IActiveLogic)logic).getActive();
        }
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public abstract String[] getTextureNames();

    public abstract String getTextureDomain(int var1);

    public void func_149651_a(IIconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.getTextureDomain(i) + ":" + textureNames[i]);
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != null && player.func_70694_bm().func_77973_b() == Items.field_151055_y && (te = world.func_147438_o(x, y, z)) instanceof IDebuggable) {
            DebugHelper.handleDebugData(((IDebuggable)te).getDebugInfo(player));
        }
        super.func_149699_a(world, x, y, z, player);
    }
}

