/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.buffer.TileBuffer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlockWithMetadata;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockItemBuffer
extends ItemBlockWithMetadata {
    public BlockItemBuffer(Block block) {
        super(block, block);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Type type : Type.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return Type.values()[stack.func_77960_j()].getUnlocalizedName();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        TileEntity te;
        super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (world.func_147439_a(x, y, z) == this.field_150939_a && (te = world.func_147438_o(x, y, z)) instanceof TileBuffer) {
            TileBuffer buffer = (TileBuffer)te;
            Type t = Type.values()[metadata];
            buffer.setHasInventory(t.hasInventory);
            buffer.setHasPower(t.hasPower);
            buffer.setCreative(t.isCreative);
        }
        return true;
    }

    public static enum Type {
        ITEM(true, false, false),
        POWER(false, true, false),
        OMNI(true, true, false),
        CREATIVE(true, true, true);

        final boolean hasInventory;
        final boolean hasPower;
        final boolean isCreative;

        private Type(boolean hasInventory, boolean hasPower, boolean isCreative) {
            this.hasInventory = hasInventory;
            this.hasPower = hasPower;
            this.isCreative = isCreative;
        }

        public static Type get(TileBuffer buffer) {
            return !buffer.hasPower() ? ITEM : (!buffer.hasInventory() ? POWER : (!buffer.isCreative() ? OMNI : CREATIVE));
        }

        public String getUnlocalizedName() {
            return "tile." + ModObject.blockBuffer.unlocalisedName + "." + this.name().toLowerCase();
        }

        public static ItemStack getStack(Type type) {
            return new ItemStack((Block)EnderIO.blockBuffer, 1, type.ordinal());
        }
    }
}

