/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.block;

import cofh.api.block.IDismantleable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.EnderTech;
import io.endertech.block.BlockET;
import io.endertech.multiblock.IMultiblockPart;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.controller.ControllerTank;
import io.endertech.multiblock.tile.TileTankEnergyInput;
import io.endertech.multiblock.tile.TileTankPart;
import io.endertech.multiblock.tile.TileTankValve;
import io.endertech.util.BlockCoord;
import io.endertech.util.IOutlineDrawer;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTankPart
extends BlockET
implements ITileEntityProvider,
IOutlineDrawer,
IDismantleable {
    public static final int FRAME_METADATA_BASE = 0;
    public static final int FRAME_CORNER = 1;
    public static final int FRAME_CENTER = 2;
    public static final int FRAME_VERTICAL = 3;
    public static final int FRAME_EASTWEST = 4;
    public static final int FRAME_NORTHSOUTH = 5;
    public static final int VALVE_BASE = 6;
    public static final int ENERGY_INPUT_BASE = 7;
    public static final String TEXTURE_BASE = "endertech:enderTankPart";
    public static ItemStack itemBlockTankFrame;
    public static ItemStack itemBlockTankValve;
    public static ItemStack itemBlockTankEnergyInput;
    private static String[] _subBlocks;
    private IIcon[] _icons = new IIcon[_subBlocks.length];

    public BlockTankPart() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(EnderTech.tabET);
        this.func_149663_c("enderTankPart");
        this.func_149658_d(TEXTURE_BASE);
    }

    public static boolean isFrame(int metadata) {
        return metadata >= 0 && metadata <= 5;
    }

    public static boolean isValve(int metadata) {
        return metadata == 6;
    }

    public static boolean isEnergyInput(int metadata) {
        return metadata == 7;
    }

    public static boolean onTankBlockActivated(World world, int x, int y, int z, EntityPlayer player, int faceHit, float par7, float par8, float par9) {
        TileEntity te;
        ItemStack currentEquippedItem;
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && (currentEquippedItem = player.func_71045_bC()) == null && (te = world.func_147438_o(x, y, z)) instanceof IMultiblockPart) {
            MultiblockControllerBase controller = ((IMultiblockPart)te).getMultiblockController();
            if (controller != null) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Ender Tank"));
                List<String> tooltipLines = controller.getWailaBody();
                for (String line : tooltipLines) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(" " + line));
                }
                MultiblockValidationException e = controller.getLastValidationException();
                if (e != null) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(LocalisationHelper.localiseString("info.multiblock.construction.last_failure_reason.pre", new Object[0])));
                    player.func_146105_b((IChatComponent)new ChatComponentText(e.getMessage()));
                }
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText(LocalisationHelper.localiseString("info.multiblock.construction.no_controller", new Object[0])));
                return true;
            }
        }
        return false;
    }

    public static boolean canPlaceTankPartAt(World world, int x, int y, int z) {
        HashSet<Integer> randomNumbers = new HashSet<Integer>();
        for (ForgeDirection neighbour : ForgeDirection.VALID_DIRECTIONS) {
            boolean hasContents;
            ControllerTank controller;
            TileEntity tile = world.func_147438_o(x + neighbour.offsetX, y + neighbour.offsetY, z + neighbour.offsetZ);
            if (!(tile instanceof TileTankPart) || (controller = ((TileTankPart)tile).getTankController()) == null) continue;
            boolean bl = hasContents = controller.tank.getFluidAmount() > 0 || controller.getStoredEnergy() > 0;
            if (!hasContents) continue;
            int randomNumber = controller.getRandomNumber();
            if (!randomNumbers.contains(randomNumber)) {
                randomNumbers.add(randomNumber);
            }
            if (randomNumbers.size() <= 1) continue;
            LogHelper.info(LocalisationHelper.localiseString("info.multiblock.tank.connecting_destructive", new BlockCoord(x, y, z).toString()), new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean isLastPartWithContents(World world, BlockCoord coord) {
        TileEntity tile = world.func_147438_o(coord.x, coord.y, coord.z);
        if (!(tile instanceof TileTankPart)) {
            return false;
        }
        ControllerTank controller = ((TileTankPart)tile).getTankController();
        if (controller == null || controller.getStoredEnergy() <= 0 && controller.tank.getFluidAmount() <= 0) {
            return false;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity neighbourTile = world.func_147438_o(coord.x + direction.offsetX, coord.y + direction.offsetY, coord.z + direction.offsetZ);
            if (!(neighbourTile instanceof TileTankPart)) continue;
            return false;
        }
        return true;
    }

    public static boolean canDismantleTankBlock(EntityPlayer player, World world, int x, int y, int z) {
        boolean dismantleWouldBeDestructive = BlockTankPart.isLastPartWithContents(world, new BlockCoord(x, y, z));
        if (dismantleWouldBeDestructive) {
            player.func_146105_b((IChatComponent)new ChatComponentText(LocalisationHelper.localiseString("warning.tank.dismantle_loss", new Object[0])));
        }
        return !dismantleWouldBeDestructive;
    }

    public void init() {
        TileTankPart.init();
        TileTankValve.init();
        TileTankEnergyInput.init();
        itemBlockTankFrame = new ItemStack((Block)this, 1, 0);
        itemBlockTankValve = new ItemStack((Block)this, 1, 6);
        itemBlockTankEnergyInput = new ItemStack((Block)this, 1, 7);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata >= 0 && metadata <= 5) {
            return new TileTankPart();
        }
        if (metadata == 6) {
            return new TileTankValve();
        }
        if (metadata == 7) {
            return new TileTankEnergyInput();
        }
        throw new IllegalArgumentException("Unrecognized metadata: " + metadata);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int faceHit, float par7, float par8, float par9) {
        boolean overridden = super.func_149727_a(world, x, y, z, player, faceHit, par7, par8, par9);
        if (!overridden) {
            overridden = BlockTankPart.onTankBlockActivated(world, x, y, z, player, faceHit, par7, par8, par9);
        }
        return overridden;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public ItemStack getTankFrameItemStack() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getTankValveItemStack() {
        return new ItemStack((Block)this, 1, 6);
    }

    public ItemStack getTankEnergyInputItemStack() {
        return new ItemStack((Block)this, 1, 7);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getTankFrameItemStack());
        par3List.add(this.getTankValveItemStack());
        par3List.add(this.getTankEnergyInputItemStack());
    }

    @Override
    public boolean drawOutline(DrawBlockHighlightEvent event) {
        BlockCoord target = new BlockCoord(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        World world = event.player.field_70170_p;
        TileEntity tile = world.func_147438_o(target.x, target.y, target.z);
        if (tile instanceof TileTankPart) {
            return ((TileTankPart)tile).drawOutline(event);
        }
        return false;
    }

    public int func_149692_a(int meta) {
        if (BlockTankPart.isFrame(meta)) {
            return 0;
        }
        if (BlockTankPart.isValve(meta)) {
            return 6;
        }
        if (BlockTankPart.isEnergyInput(meta)) {
            return 7;
        }
        return 0;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return BlockTankPart.canPlaceTankPartAt(world, x, y, z);
    }

    public IIcon func_149691_a(int side, int metadata) {
        switch (metadata) {
            case 0: {
                return this._icons[0];
            }
            case 1: {
                return this._icons[1];
            }
            case 2: {
                return this._icons[2];
            }
            case 3: {
                if (side == 0 || side == 1) {
                    return this._icons[0];
                }
                return this._icons[metadata];
            }
            case 4: {
                if (side == 4 || side == 5) {
                    return this._icons[0];
                }
                return this._icons[metadata];
            }
            case 5: {
                if (side == 2 || side == 3) {
                    return this._icons[0];
                }
                if (side == 4 || side == 5) {
                    return this._icons[4];
                }
                return this._icons[metadata];
            }
            case 6: {
                return this._icons[6];
            }
            case 7: {
                return this._icons[7];
            }
        }
        if (side == 0 || side == 1) {
            return this._icons[0];
        }
        metadata = Math.max(0, Math.min(6, metadata));
        return this._icons[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(TEXTURE_BASE);
        for (int i = 0; i < _subBlocks.length; ++i) {
            this._icons[i] = iconRegister.func_94245_a("endertech:enderTankPart." + _subBlocks[i]);
        }
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        return BlockET.dismantleBlockInWorld(player, world, x, y, z, returnDrops);
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return BlockTankPart.canDismantleTankBlock(player, world, x, y, z);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    static {
        _subBlocks = new String[]{"frameDefault", "frameCorner", "frameCenter", "frameVertical", "frameEastWest", "frameNorthSouth", "valve", "energyInput"};
    }
}

