/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.transport;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.LinkedHashList;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.position.BlockPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.core.ArrayHashList;
import powercrystals.minefactoryreloaded.core.IGrid;
import powercrystals.minefactoryreloaded.net.GridTickHandler;
import powercrystals.minefactoryreloaded.tile.transport.TileEntityPlasticPipe;

public class FluidNetwork
implements IGrid {
    public static final int TRANSFER_RATE = 80;
    public static final int STORAGE = 480;
    static final GridTickHandler<FluidNetwork, TileEntityPlasticPipe> HANDLER = GridTickHandler.fluid;
    private ArrayHashList<TileEntityPlasticPipe> nodeSet = new ArrayHashList();
    private LinkedHashList<TileEntityPlasticPipe> conduitSet;
    private TileEntityPlasticPipe master;
    private int overflowSelector;
    private boolean regenerating = false;
    FluidTankAdv storage = new FluidTankAdv(320);
    public int distribution;
    public int distributionSide;

    protected FluidNetwork() {
        this.storage.setCapacity(0);
    }

    public FluidNetwork(TileEntityPlasticPipe tileEntityPlasticPipe) {
        this();
        this.conduitSet = new LinkedHashList();
        this.regenerating = true;
        this.addConduit(tileEntityPlasticPipe);
        this.regenerating = false;
    }

    public int getNodeShare(TileEntityPlasticPipe tileEntityPlasticPipe) {
        int n = this.nodeSet.size();
        if (n == 1) {
            return this.storage.getFluidAmount();
        }
        int n2 = 0;
        if (this.master == tileEntityPlasticPipe) {
            n2 = this.storage.getFluidAmount() % n;
        }
        return n2 + this.storage.getFluidAmount() / n;
    }

    public void addConduit(TileEntityPlasticPipe tileEntityPlasticPipe) {
        if (this.conduitSet.add((Object)tileEntityPlasticPipe) && !this.conduitAdded(tileEntityPlasticPipe)) {
            return;
        }
        if (tileEntityPlasticPipe.isNode) {
            if (this.nodeSet.add(tileEntityPlasticPipe)) {
                this.nodeAdded(tileEntityPlasticPipe);
            }
        } else if (!this.nodeSet.isEmpty()) {
            int n = this.getNodeShare(tileEntityPlasticPipe);
            if (this.nodeSet.remove(tileEntityPlasticPipe)) {
                tileEntityPlasticPipe.fluidForGrid = this.storage.drain(n, true);
                this.nodeRemoved(tileEntityPlasticPipe);
            }
        }
    }

    public void removeConduit(TileEntityPlasticPipe tileEntityPlasticPipe) {
        this.conduitSet.remove((Object)tileEntityPlasticPipe);
        if (!this.nodeSet.isEmpty()) {
            int n = this.getNodeShare(tileEntityPlasticPipe);
            if (this.nodeSet.remove(tileEntityPlasticPipe)) {
                tileEntityPlasticPipe.fluidForGrid = this.storage.drain(n, true);
                this.nodeRemoved(tileEntityPlasticPipe);
            }
        }
        this.rebalanceGrid();
    }

    public void regenerate() {
        this.regenerating = true;
        HANDLER.regenerateGrid(this);
    }

    public boolean isRegenerating() {
        return this.regenerating;
    }

    @Override
    public void markSweep() {
        FluidNetwork fluidNetwork;
        this.destroyGrid();
        if (this.conduitSet.isEmpty()) {
            return;
        }
        TileEntityPlasticPipe tileEntityPlasticPipe = (TileEntityPlasticPipe)this.conduitSet.poke();
        LinkedHashList<TileEntityPlasticPipe> linkedHashList = this.conduitSet;
        this.nodeSet.clear();
        this.conduitSet = new LinkedHashList(Math.min(linkedHashList.size() / 6, 5));
        this.rebalanceGrid();
        LinkedHashList linkedHashList2 = new LinkedHashList();
        LinkedHashList linkedHashList3 = new LinkedHashList();
        BlockPosition blockPosition = new BlockPosition(0, 0, 0);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        linkedHashList2.add((Object)tileEntityPlasticPipe);
        linkedHashList3.add((Object)tileEntityPlasticPipe);
        while (!linkedHashList2.isEmpty()) {
            tileEntityPlasticPipe = (TileEntityPlasticPipe)linkedHashList2.shift();
            this.addConduit(tileEntityPlasticPipe);
            fluidNetwork = tileEntityPlasticPipe.func_145831_w();
            int n = 6;
            while (n-- > 0) {
                TileEntityPlasticPipe tileEntityPlasticPipe2;
                TileEntity tileEntity;
                blockPosition.x = tileEntityPlasticPipe.field_145851_c;
                blockPosition.y = tileEntityPlasticPipe.field_145848_d;
                blockPosition.z = tileEntityPlasticPipe.field_145849_e;
                blockPosition.step(forgeDirectionArray[n]);
                if (!fluidNetwork.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z) || !((tileEntity = blockPosition.getTileEntity((World)fluidNetwork)) instanceof TileEntityPlasticPipe) || !tileEntityPlasticPipe.canInterface(tileEntityPlasticPipe2 = (TileEntityPlasticPipe)tileEntity, forgeDirectionArray[n ^ 1]) || !linkedHashList3.add((Object)tileEntityPlasticPipe2)) continue;
                linkedHashList2.add((Object)tileEntityPlasticPipe2);
            }
            linkedHashList.remove((Object)tileEntityPlasticPipe);
        }
        if (!linkedHashList.isEmpty()) {
            fluidNetwork = new FluidNetwork();
            fluidNetwork.conduitSet = linkedHashList;
            fluidNetwork.regenerating = true;
            fluidNetwork.markSweep();
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
        } else {
            HANDLER.addGrid(this);
        }
        this.regenerating = false;
    }

    public void destroyGrid() {
        this.master = null;
        this.regenerating = true;
        for (TileEntityPlasticPipe tileEntityPlasticPipe : this.nodeSet) {
            this.destroyNode(tileEntityPlasticPipe);
        }
        for (TileEntityPlasticPipe tileEntityPlasticPipe : this.conduitSet) {
            this.destroyConduit(tileEntityPlasticPipe);
        }
        HANDLER.removeGrid(this);
    }

    public void destroyNode(TileEntityPlasticPipe tileEntityPlasticPipe) {
        tileEntityPlasticPipe.fluidForGrid = this.storage.drain(this.getNodeShare(tileEntityPlasticPipe), false);
        tileEntityPlasticPipe._grid = null;
    }

    public void destroyConduit(TileEntityPlasticPipe tileEntityPlasticPipe) {
        tileEntityPlasticPipe.fluidForGrid = this.storage.drain(0, false);
        tileEntityPlasticPipe._grid = null;
    }

    @Override
    public void doGridPreUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
            return;
        }
        FluidTankAdv fluidTankAdv = this.storage;
        if (fluidTankAdv.getSpace() <= 0) {
            return;
        }
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        for (TileEntityPlasticPipe tileEntityPlasticPipe : this.nodeSet) {
            int n = 6;
            while (n-- > 0) {
                tileEntityPlasticPipe.extract(forgeDirectionArray[n], (IFluidTank)fluidTankAdv);
            }
        }
    }

    @Override
    public void doGridUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
            return;
        }
        FluidTankAdv fluidTankAdv = this.storage;
        if (fluidTankAdv.getFluidAmount() <= 0) {
            return;
        }
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = this.nodeSet.size();
        int n2 = fluidTankAdv.getFluidAmount() / n;
        int n3 = n2 / 6;
        Fluid fluid = fluidTankAdv.getFluid().getFluid();
        this.distribution = n2;
        this.distributionSide = n3;
        FluidStack fluidStack = fluidTankAdv.drain(n3, false);
        int n4 = this.overflowSelector = (this.overflowSelector + 1) % n;
        TileEntityPlasticPipe tileEntityPlasticPipe = this.nodeSet.get(n4);
        if (n3 > 0) {
            for (TileEntityPlasticPipe tileEntityPlasticPipe2 : this.nodeSet) {
                if (tileEntityPlasticPipe2 == tileEntityPlasticPipe) continue;
                int n5 = 0;
                int n6 = 6;
                while (n6-- > 0) {
                    n5 += tileEntityPlasticPipe2.transfer(forgeDirectionArray[n6], fluidStack, fluid);
                }
                if (n5 <= 0) continue;
                fluidTankAdv.drain(n5, true);
            }
        }
        fluidStack.amount = n3 = (n2 += fluidTankAdv.getFluidAmount() % n) / 6;
        if (n3 > 0) {
            int n7 = 0;
            int n8 = 6;
            while (n8-- > 0) {
                n7 += tileEntityPlasticPipe.transfer(forgeDirectionArray[n8], fluidStack, fluid);
            }
            if (n7 > 0) {
                fluidTankAdv.drain(n7, true);
            }
        } else if (n2 > 0) {
            fluidStack.amount = n2;
            int n9 = 0;
            int n10 = 6;
            while (n10-- > 0 && n9 < n2) {
                fluidStack.amount = n2 - (n9 += tileEntityPlasticPipe.transfer(forgeDirectionArray[n10], fluidStack, fluid));
            }
            if (n9 > 0) {
                fluidTankAdv.drain(n9, true);
            }
        }
    }

    public boolean canMergeGrid(FluidNetwork fluidNetwork) {
        if (fluidNetwork == null) {
            return false;
        }
        return FluidHelper.isFluidEqual((FluidStack)fluidNetwork.storage.getFluid(), (FluidStack)this.storage.getFluid());
    }

    public void mergeGrid(FluidNetwork fluidNetwork) {
        if (fluidNetwork == this) {
            return;
        }
        if (this.storage.getFluid() == null && fluidNetwork.storage.getFluid() != null) {
            fluidNetwork.mergeGrid(this);
            return;
        }
        boolean bl = this.regenerating | fluidNetwork.regenerating;
        fluidNetwork.destroyGrid();
        if (!this.regenerating & bl) {
            this.regenerate();
        }
        this.regenerating = true;
        for (TileEntityPlasticPipe tileEntityPlasticPipe : fluidNetwork.conduitSet) {
            this.addConduit(tileEntityPlasticPipe);
        }
        this.regenerating = bl;
        fluidNetwork.conduitSet.clear();
        fluidNetwork.nodeSet.clear();
    }

    public void nodeAdded(TileEntityPlasticPipe tileEntityPlasticPipe) {
        if (this.master == null) {
            this.master = tileEntityPlasticPipe;
            HANDLER.addGrid(this);
        }
        this.storage.fill(tileEntityPlasticPipe.fluidForGrid, true);
        tileEntityPlasticPipe.fluidForGrid = this.storage.drain(0, false);
    }

    public void nodeRemoved(TileEntityPlasticPipe tileEntityPlasticPipe) {
        if (tileEntityPlasticPipe == this.master) {
            if (this.nodeSet.isEmpty()) {
                this.master = null;
                HANDLER.removeGrid(this);
            } else {
                this.master = this.nodeSet.get(0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conduitAdded(TileEntityPlasticPipe tileEntityPlasticPipe) {
        if (tileEntityPlasticPipe._grid != null) {
            if (tileEntityPlasticPipe._grid == this) return false;
            this.conduitSet.remove((Object)tileEntityPlasticPipe);
            if (!this.canMergeGrid(tileEntityPlasticPipe._grid)) return false;
            this.mergeGrid(tileEntityPlasticPipe._grid);
        } else if (tileEntityPlasticPipe.fluidForGrid != null) {
            if (!FluidHelper.isFluidEqualOrNull((FluidStack)tileEntityPlasticPipe.fluidForGrid, (FluidStack)this.storage.getFluid())) {
                this.conduitSet.remove((Object)tileEntityPlasticPipe);
                return false;
            }
            tileEntityPlasticPipe.setGrid(this);
            this.storage.fill(new FluidStack(tileEntityPlasticPipe.fluidForGrid.fluidID, 0), true);
        } else {
            tileEntityPlasticPipe.setGrid(this);
        }
        this.rebalanceGrid();
        return true;
    }

    public void rebalanceGrid() {
        this.storage.setCapacity(this.conduitSet.size() * 480);
    }

    public int getConduitCount() {
        return this.conduitSet.size();
    }

    public int getNodeCount() {
        return this.nodeSet.size();
    }

    public String toString() {
        return "FluidNetwork@" + Integer.toString(this.hashCode()) + "; master:" + this.master + "; regenerating:" + this.regenerating + "; isTicking:" + HANDLER.isGridTicking(this);
    }
}

