/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes.entries;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.io.File;
import openeye.notes.NoteCategory;
import openeye.notes.WrappedChatComponent;
import openeye.notes.entries.NoteEntry;
import openeye.responses.ResponseRemoveFile;

public class RemoveFileEntry
extends NoteEntry {
    private final String signature;
    private final String url;

    public RemoveFileEntry(File file, ResponseRemoveFile msg) {
        super(file, NoteCategory.REMOVE_FILE, 128);
        this.signature = msg.signature;
        this.url = msg.url;
    }

    @Override
    public WrappedChatComponent title() {
        return WrappedChatComponent.createTranslation("openeye.notes.title.remove_file", this.file.getName());
    }

    @Override
    public WrappedChatComponent content() {
        return WrappedChatComponent.createTranslation("openeye.notes.content.remove_file", this.file.getName());
    }

    @Override
    public String url() {
        return Strings.nullToEmpty((String)this.url);
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = super.toJson();
        result.addProperty("signature", this.signature);
        return result;
    }
}

