/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import crazypants.enderio.config.Config;
import crazypants.render.BoundingBox;
import crazypants.render.VertexRotation;
import crazypants.render.VertexTransform;
import crazypants.vecmath.Vector3d;

public class RedstoneSwitchBounds {
    private static RedstoneSwitchBounds instance;
    final VertexTransform[] xForms;
    final BoundingBox switchBounds;
    final BoundingBox connectorBounds;
    private final BoundingBox[] aabb;

    public static final RedstoneSwitchBounds getInstance() {
        if (instance == null) {
            instance = new RedstoneSwitchBounds();
        }
        return instance;
    }

    RedstoneSwitchBounds() {
        int i;
        float conduitScale = (float)Config.conduitScale;
        float size = Math.max(0.2f, conduitScale * 0.5f);
        float halfWidth = size / 3.0f;
        float halfHeight = size / 2.0f;
        float halfDepth = 0.025f;
        float distance = Math.max(0.25f, conduitScale * 0.3f);
        BoundingBox bb = new BoundingBox(0.5 - (double)halfWidth, 0.5 - (double)halfHeight, 0.5 - (double)halfDepth, 0.5 + (double)halfWidth, 0.5 + (double)halfHeight, 0.5 + (double)halfDepth);
        this.switchBounds = bb.translate(0.0f, 0.0f, distance);
        float connectorHalfWidth = (float)Math.max(0.015, (double)conduitScale * 0.05);
        this.connectorBounds = new BoundingBox(0.5 - (double)connectorHalfWidth, 0.5 - (double)connectorHalfWidth, 0.5 - (double)connectorHalfWidth, 0.5 + (double)connectorHalfWidth, 0.5 + (double)connectorHalfWidth, 0.5 + (double)distance);
        Vector3d axis = new Vector3d(0.0, 1.0, 0.0);
        Vector3d p = new Vector3d(0.5, 0.5, 0.5);
        this.xForms = new VertexTransform[4];
        double angle = Math.toRadians(45.0);
        for (i = 0; i < this.xForms.length; ++i) {
            this.xForms[i] = new VertexRotation(angle, axis, p);
            angle += Math.toRadians(90.0);
        }
        this.aabb = new BoundingBox[this.xForms.length];
        for (i = 0; i < this.xForms.length; ++i) {
            this.aabb[i] = this.switchBounds.transform(this.xForms[i]);
        }
    }

    public BoundingBox[] getAABB() {
        return this.aabb;
    }
}

