/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.network.NetworkTools;

public class PacketCheckDimletConfig
implements IMessage {
    private Map<Integer, DimletKey> dimlets;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.dimlets = new HashMap<Integer, DimletKey>();
        for (int i = 0; i < size; ++i) {
            int id = buf.readInt();
            String name = NetworkTools.readString(buf);
            int typeOrdinal = buf.readInt();
            try {
                this.dimlets.put(id, new DimletKey(DimletType.values()[typeOrdinal], name));
                continue;
            }
            catch (Exception e) {
                RFTools.logError("INTERNAL ERROR: name=" + name + ", i=" + i + ", size=" + size + "!");
                throw new RuntimeException(e);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimlets.size());
        for (Map.Entry<Integer, DimletKey> me : this.dimlets.entrySet()) {
            DimletKey key = me.getValue();
            buf.writeInt(me.getKey().intValue());
            NetworkTools.writeString(buf, key.getName());
            buf.writeInt(key.getType().ordinal());
        }
    }

    public Map<Integer, DimletKey> getDimlets() {
        return this.dimlets;
    }

    public PacketCheckDimletConfig() {
    }

    public PacketCheckDimletConfig(Map<Integer, DimletKey> dimlets) {
        this.dimlets = new HashMap<Integer, DimletKey>(dimlets);
    }
}

