/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.transform;

import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import tterrag.core.TTCore;
import tterrag.core.common.transform.TTCorePlugin;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class TTCoreTransformer
implements IClassTransformer {
    private static final String worldTypeClass = "net.minecraft.world.WorldType";
    private static final ObfSafeName voidFogMethod = new ObfSafeName("hasVoidParticles", "func_76564_j");
    private static final String voidFogMethodSig = "(Lnet/minecraft/world/WorldType;Z)Z";
    private static final String anvilContainerClass = "net.minecraft.inventory.ContainerRepair";
    private static final ObfSafeName anvilContainerMethod = new ObfSafeName("updateRepairOutput", "func_82848_d");
    private static final String anvilGuiClass = "net.minecraft.client.gui.GuiRepair";
    private static final ObfSafeName anvilGuiMethod = new ObfSafeName("drawGuiContainerForegroundLayer", "func_146979_b");
    private static final String enchantHelperClass = "net.minecraft.enchantment.EnchantmentHelper";
    private static final String enchantHelperMethodSig = "(Lnet/minecraft/item/ItemStack;I)I";
    private static final ObfSafeName buildEnchantListMethod = new ObfSafeName("buildEnchantmentList", "func_77513_b");
    private static final ObfSafeName calcEnchantabilityMethod = new ObfSafeName("calcItemStackEnchantability", "func_77514_a");
    private static final String itemStackClass = "net.minecraft.item.ItemStack";
    private static final ObfSafeName itemStackMethod = new ObfSafeName("getRarity", "func_77953_t");
    private static final String itemStackMethodSig = "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/EnumRarity;";
    private static final String entityArrowClass = "net.minecraft.entity.projectile.EntityArrow";
    private static final ObfSafeName entityArrowMethod = new ObfSafeName("onUpdate", "func_70071_h_");
    private static final String entityArrowMethodSig = "(Lnet/minecraft/entity/projectile/EntityArrow;)V";
    private static final String containerFurnaceClass = "net.minecraft.inventory.ContainerFurnace";
    private static final ObfSafeName containerFurnaceMethod = new ObfSafeName("transferStackInSlot", "func_82846_b");
    private static final String containerFurnaceMethodSig = "(Lnet/minecraft/inventory/ContainerFurnace;Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(worldTypeClass)) {
            basicClass = this.transform(basicClass, worldTypeClass, voidFogMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!voidFogMethod.equals(m.name)) continue;
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
                        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "tterrag/core/common/transform/TTCoreMethods", "hasVoidParticles", TTCoreTransformer.voidFogMethodSig, false));
                        m.instructions.add((AbstractInsnNode)new InsnNode(172));
                        break;
                    }
                }
            });
        } else if (transformedName.equals(anvilContainerClass) || transformedName.equals(anvilGuiClass)) {
            basicClass = this.transform(basicClass, anvilContainerClass, anvilContainerMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!anvilContainerMethod.equals(m.name) && !anvilGuiMethod.equals(m.name)) continue;
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode next = m.instructions.get(i);
                            next = m.instructions.get(i);
                            if (!(next instanceof IntInsnNode) || ((IntInsnNode)next).operand != 40) continue;
                            m.instructions.set(next, (AbstractInsnNode)new MethodInsnNode(184, "tterrag/core/common/transform/TTCoreMethods", "getMaxAnvilCost", "()I", false));
                        }
                    }
                }
            });
        } else if (transformedName.equals(enchantHelperClass)) {
            final HashMap<String, int[]> data = new HashMap<String, int[]>();
            data.put(buildEnchantListMethod.getName(), new int[]{1, 4});
            data.put(calcEnchantabilityMethod.getName(), new int[]{3, 5});
            Transform transformer = new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    block0: while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!data.keySet().contains(m.name)) continue;
                        int[] indeces = (int[])data.get(m.name);
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            VarInsnNode varNode;
                            AbstractInsnNode next = m.instructions.get(i);
                            if (!(next instanceof VarInsnNode) || (varNode = (VarInsnNode)next).getOpcode() != 54 || varNode.var != indeces[1]) continue;
                            InsnList toAdd = new InsnList();
                            toAdd.add((AbstractInsnNode)new VarInsnNode(25, indeces[0]));
                            toAdd.add((AbstractInsnNode)new VarInsnNode(21, indeces[1]));
                            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "tterrag/core/common/transform/TTCoreMethods", "getItemEnchantability", TTCoreTransformer.enchantHelperMethodSig, false));
                            toAdd.add((AbstractInsnNode)new VarInsnNode(54, indeces[1]));
                            m.instructions.insert(next, toAdd);
                            break block0;
                        }
                    }
                }
            };
            basicClass = this.transform(basicClass, enchantHelperClass, buildEnchantListMethod, transformer);
        } else if (transformedName.equals(itemStackClass)) {
            basicClass = this.transform(basicClass, itemStackClass, itemStackMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!itemStackMethod.equals(m.name)) continue;
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "tterrag/core/common/transform/TTCoreMethods", "getItemRarity", TTCoreTransformer.itemStackMethodSig, false));
                        m.instructions.add((AbstractInsnNode)new InsnNode(176));
                        break;
                    }
                }
            });
        } else if (transformedName.equals(entityArrowClass)) {
            basicClass = this.transform(basicClass, entityArrowClass, entityArrowMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    block0: while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!entityArrowMethod.equals(m.name)) continue;
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode next = m.instructions.get(i);
                            if (!(next instanceof MethodInsnNode)) continue;
                            InsnList toAdd = new InsnList();
                            toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "tterrag/core/common/transform/TTCoreMethods", "onArrowUpdate", TTCoreTransformer.entityArrowMethodSig, false));
                            m.instructions.insert(next, toAdd);
                            break block0;
                        }
                    }
                }
            });
        } else if (transformedName.equals(containerFurnaceClass)) {
            basicClass = this.transform(basicClass, containerFurnaceClass, containerFurnaceMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!containerFurnaceMethod.equals(m.name)) continue;
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
                        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "tterrag/core/common/transform/TTCoreMethods", "transferStackInSlot", TTCoreTransformer.containerFurnaceMethodSig, false));
                        m.instructions.add((AbstractInsnNode)new InsnNode(176));
                        break;
                    }
                }
            });
        }
        return basicClass;
    }

    protected final byte[] transform(byte[] classBytes, String className, ObfSafeName methodName, Transform transformer) {
        TTCore.logger.info("Transforming Class [" + className + "], Method [" + methodName.getName() + "]");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Iterator<MethodNode> methods = classNode.methods.iterator();
        transformer.transform(methods);
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        TTCore.logger.info("Transforming " + className + " Finished.");
        return cw.toByteArray();
    }

    protected static abstract class Transform {
        protected Transform() {
        }

        abstract void transform(Iterator<MethodNode> var1);
    }

    protected static class ObfSafeName {
        private String deobf;
        private String srg;

        public String getName() {
            return TTCorePlugin.runtimeDeobfEnabled ? this.srg : this.deobf;
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                return obj.equals(this.deobf) || obj.equals(this.srg);
            }
            if (obj instanceof ObfSafeName) {
                return ((ObfSafeName)obj).deobf.equals(this.deobf) && ((ObfSafeName)obj).srg.equals(this.srg);
            }
            return false;
        }

        @ConstructorProperties(value={"deobf", "srg"})
        public ObfSafeName(String deobf, String srg) {
            this.deobf = deobf;
            this.srg = srg;
        }
    }
}

