/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import java.util.ArrayList;
import mal.lootbags.BagTypes;
import net.minecraft.util.WeightedRandomChestContent;

public class LootItem {
    private WeightedRandomChestContent item;
    private BagTypes[] possibleBags = new BagTypes[BagTypes.droppableValues().length];

    public LootItem(WeightedRandomChestContent item, BagTypes min, BagTypes max) {
        this.item = item;
        int sindex = min.getIndex();
        int eindex = max.getIndex();
        if (sindex < eindex) {
            for (int i = sindex; i <= eindex; ++i) {
                this.possibleBags[i] = BagTypes.droppableValues()[i];
            }
        } else if (sindex > eindex) {
            for (int i = eindex; i <= sindex; ++i) {
                this.possibleBags[i] = BagTypes.droppableValues()[i];
            }
        } else {
            this.possibleBags[sindex] = BagTypes.droppableValues()[sindex];
        }
    }

    public LootItem(WeightedRandomChestContent item, BagTypes type) {
        this(item, type, type);
    }

    public LootItem(WeightedRandomChestContent item, ArrayList<BagTypes> types) {
        this.item = item;
        for (int i = 0; i < types.size(); ++i) {
            if (types.get(i) == null) continue;
            this.possibleBags[types.get((int)i).getIndex()] = types.get(i);
        }
    }

    public void addBagType(BagTypes type) {
        int index = type.getIndex();
        this.possibleBags[index] = type;
    }

    public void removeBagType(BagTypes type) {
        int index = type.getIndex();
        this.possibleBags[index] = null;
    }

    public void removeBagTypes(ArrayList<BagTypes> type) {
        for (int i = 0; i < type.size(); ++i) {
            this.removeBagType(type.get(i));
        }
    }

    public boolean canDrop(BagTypes type) {
        return this.possibleBags[type.getIndex()] != null;
    }

    public BagTypes[] getPossibleBags() {
        return this.possibleBags;
    }

    public WeightedRandomChestContent getContentItem() {
        return this.item;
    }
}

