/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.api.block.IDismantleable;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IToolHammer;
import cofh.asm.relauncher.Implementable;
import cofh.core.item.IEqualityOverrideItem;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.core.RAProps;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@Implementable(value={"buildcraft.api.tools.IToolWrench", "mods.railcraft.api.core.items.IToolCrowbar"})
public class ItemWrenchRF
extends ItemShears
implements IEnergyContainerItem,
IToolHammer,
IEqualityOverrideItem {
    protected Item.ToolMaterial toolMaterial;
    IIcon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;

    public ItemWrenchRF(Item.ToolMaterial toolMaterial) {
        this.toolMaterial = toolMaterial;
        this.func_77656_e(toolMaterial.func_77997_a());
        this.setNoRepair();
    }

    public ItemWrenchRF setEnergyParams(int n, int n2, int n3, int n4) {
        this.maxEnergy = n;
        this.maxTransfer = n2;
        this.energyPerUse = n3;
        return this;
    }

    protected int useEnergy(ItemStack itemStack, boolean bl) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return this.extractEnergy(itemStack, this.energyPerUse * (5 - n) / 5, bl);
    }

    protected int getEnergyPerUse(ItemStack itemStack) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return this.energyPerUse * (5 - n) / 5;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase entityLivingBase, EntityLivingBase entityLivingBase2) {
        entityLivingBase.field_70177_z += 90.0f;
        entityLivingBase.field_70177_z %= 360.0f;
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        return ServerHelper.isClientWorld((World)world);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        if (itemStack.func_77960_j() > 0) {
            itemStack.func_77964_b(0);
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d && this.getEnergyStored(itemStack) < this.getEnergyPerUse(itemStack)) {
            return false;
        }
        Block block = world.func_147439_a(n, n2, n3);
        if (block == null) {
            return false;
        }
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4, world);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY || playerInteractEvent.useItem == Event.Result.DENY) {
            return false;
        }
        if (ServerHelper.isServerWorld((World)world) && entityPlayer.func_70093_af() && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(entityPlayer, world, n, n2, n3)) {
            ((IDismantleable)block).dismantleBlock(entityPlayer, world, n, n2, n3, false);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.useEnergy(itemStack, false);
            }
            return true;
        }
        if (BlockHelper.canRotate((Block)block)) {
            if (entityPlayer.func_70093_af()) {
                world.func_72921_c(n, n2, n3, BlockHelper.rotateVanillaBlockAlt((World)world, (Block)block, (int)n, (int)n2, (int)n3), 3);
                world.func_72908_a((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, block.field_149762_H.func_150495_a(), 1.0f, 0.6f);
            } else {
                world.func_72921_c(n, n2, n3, BlockHelper.rotateVanillaBlock((World)world, (Block)block, (int)n, (int)n2, (int)n3), 3);
                world.func_72908_a((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, block.field_149762_H.func_150495_a(), 1.0f, 0.8f);
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.useEnergy(itemStack, false);
            }
            return ServerHelper.isServerWorld((World)world);
        }
        if (!entityPlayer.func_70093_af() && block.rotateBlock(world, n, n2, n3, ForgeDirection.getOrientation((int)n4))) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.useEnergy(itemStack, false);
            }
            return ServerHelper.isServerWorld((World)world);
        }
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IWrenchable) {
            ItemStack itemStack2;
            IWrenchable iWrenchable = (IWrenchable)tileEntity;
            if (entityPlayer.func_70093_af()) {
                n4 = BlockHelper.SIDE_OPPOSITE[n4];
            }
            if (iWrenchable.wrenchCanSetFacing(entityPlayer, n4)) {
                if (ServerHelper.isServerWorld((World)world)) {
                    iWrenchable.setFacing((short)n4);
                }
            } else if (iWrenchable.wrenchCanRemove(entityPlayer) && (itemStack2 = iWrenchable.getWrenchDrop(entityPlayer)) != null) {
                world.func_147468_f(n, n2, n3);
                if (ServerHelper.isServerWorld((World)world)) {
                    ArrayList arrayList = block.getDrops(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
                    if (arrayList.isEmpty()) {
                        arrayList.add(itemStack2);
                    } else {
                        arrayList.set(0, itemStack2);
                    }
                    for (ItemStack itemStack3 : arrayList) {
                        float f4 = 0.7f;
                        double d = (double)(world.field_73012_v.nextFloat() * f4) + (double)(1.0f - f4) * 0.5;
                        double d2 = (double)(world.field_73012_v.nextFloat() * f4) + (double)(1.0f - f4) * 0.5;
                        double d3 = (double)(world.field_73012_v.nextFloat() * f4) + (double)(1.0f - f4) * 0.5;
                        EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, itemStack3);
                        entityItem.field_145804_b = 10;
                        world.func_72838_d((Entity)entityItem);
                    }
                }
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.useEnergy(itemStack, false);
            }
            return ServerHelper.isServerWorld((World)world);
        }
        return false;
    }

    public boolean func_111207_a(ItemStack itemStack, EntityPlayer entityPlayer, EntityLivingBase entityLivingBase) {
        if (ServerHelper.isClientWorld((World)entityLivingBase.field_70170_p)) {
            entityLivingBase.field_70177_z += 90.0f;
            entityLivingBase.field_70177_z %= 360.0f;
            return false;
        }
        if (entityLivingBase instanceof IShearable) {
            IShearable iShearable = (IShearable)entityLivingBase;
            if (iShearable.isShearable(itemStack, (IBlockAccess)entityLivingBase.field_70170_p, (int)entityLivingBase.field_70165_t, (int)entityLivingBase.field_70163_u, (int)entityLivingBase.field_70161_v)) {
                ArrayList arrayList = iShearable.onSheared(itemStack, (IBlockAccess)entityLivingBase.field_70170_p, (int)entityLivingBase.field_70165_t, (int)entityLivingBase.field_70163_u, (int)entityLivingBase.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemStack));
                for (ItemStack itemStack2 : arrayList) {
                    EntityItem entityItem = entityLivingBase.func_70099_a(itemStack2, 1.0f);
                    entityItem.field_70181_x += (double)(MathHelper.RANDOM.nextFloat() * 0.05f);
                    entityItem.field_70159_w += (double)((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.1f);
                    entityItem.field_70179_y += (double)((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.1f);
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    this.useEnergy(itemStack, false);
                }
                entityLivingBase.field_70177_z += 90.0f;
                entityLivingBase.field_70177_z %= 360.0f;
            }
            return true;
        }
        entityLivingBase.field_70177_z += 90.0f;
        entityLivingBase.field_70177_z %= 360.0f;
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int n, int n2, int n3, EntityPlayer entityPlayer) {
        IShearable iShearable;
        if (ServerHelper.isClientWorld((World)entityPlayer.field_70170_p)) {
            return false;
        }
        Block block = entityPlayer.field_70170_p.func_147439_a(n, n2, n3);
        if (block instanceof IShearable && (iShearable = (IShearable)block).isShearable(itemStack, (IBlockAccess)entityPlayer.field_70170_p, n, n2, n3)) {
            ArrayList arrayList = iShearable.onSheared(itemStack, (IBlockAccess)entityPlayer.field_70170_p, n, n2, n3, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemStack));
            for (ItemStack itemStack2 : arrayList) {
                float f = 0.7f;
                double d = (double)(MathHelper.RANDOM.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(MathHelper.RANDOM.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d3 = (double)(MathHelper.RANDOM.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityItem = new EntityItem(entityPlayer.field_70170_p, (double)n + d, (double)n2 + d2, (double)n3 + d3, itemStack2);
                entityItem.field_145804_b = 10;
                entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.useEnergy(itemStack, false);
            }
            entityPlayer.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
        return false;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
        if (itemStack.func_77960_j() > 0) {
            itemStack.func_77964_b(0);
        }
    }

    public boolean doesSneakBypassUse(World world, int n, int n2, int n3, EntityPlayer entityPlayer) {
        return true;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(itemStack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        list.add(StringHelper.getFlavorText((String)"info.redstonearsenal.tool.wrench"));
    }

    public void setDamage(ItemStack itemStack, int n) {
        super.setDamage(itemStack, 0);
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return !RAProps.showToolCharge ? false : itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74767_n("CreativeTab");
    }

    public boolean isDamaged(ItemStack itemStack) {
        return true;
    }

    public Multimap getAttributeModifiers(ItemStack itemStack) {
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Tool modifier", 1.0, 0));
        return hashMultimap;
    }

    public IIcon func_77650_f(ItemStack itemStack) {
        return this.getIcon(itemStack, 0);
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        return this.getEnergyStored(itemStack) <= 0 ? this.drainedIcon : ((Item)this).field_77791_bV;
    }

    public void func_94581_a(IIconRegister iIconRegister) {
        ((Item)this).field_77791_bV = iIconRegister.func_94245_a(this.func_111208_A());
        this.drainedIcon = iIconRegister.func_94245_a(this.func_111208_A() + "_Drained");
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        if (itemStack.field_77990_d.func_74764_b("Unbreakable")) {
            itemStack.field_77990_d.func_82580_o("Unbreakable");
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean canWhack(EntityPlayer entityPlayer, ItemStack itemStack, int n, int n2, int n3) {
        return this.getEnergyStored(itemStack) >= this.getEnergyPerUse(itemStack) || entityPlayer.field_71075_bZ.field_75098_d;
    }

    public void onWhack(EntityPlayer entityPlayer, ItemStack itemStack, int n, int n2, int n3) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.useEnergy(itemStack, false);
        }
        entityPlayer.func_71038_i();
    }

    public boolean canLink(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
        return entityPlayer.func_70093_af() && this.getEnergyStored(itemStack) >= this.getEnergyPerUse(itemStack) || entityPlayer.field_71075_bZ.field_75098_d;
    }

    public void onLink(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.useEnergy(itemStack, false);
        }
        entityPlayer.func_71038_i();
    }

    public boolean canBoost(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
        return !entityPlayer.func_70093_af() && this.getEnergyStored(itemStack) >= this.getEnergyPerUse(itemStack);
    }

    public void onBoost(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.useEnergy(itemStack, false);
        }
        entityPlayer.func_71038_i();
    }

    public boolean isUsable(ItemStack itemStack, EntityLivingBase entityLivingBase, int n, int n2, int n3) {
        if (entityLivingBase instanceof EntityPlayer && ((EntityPlayer)entityLivingBase).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.getEnergyStored(itemStack) >= this.getEnergyPerUse(itemStack);
    }

    public void toolUsed(ItemStack itemStack, EntityLivingBase entityLivingBase, int n, int n2, int n3) {
        if (entityLivingBase instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.useEnergy(entityPlayer.func_71045_bC(), false);
            }
        }
    }

    public boolean canWrench(EntityPlayer entityPlayer, int n, int n2, int n3) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        return this.getEnergyStored(itemStack) >= this.getEnergyPerUse(itemStack) || entityPlayer.field_71075_bZ.field_75098_d;
    }

    public void wrenchUsed(EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.useEnergy(entityPlayer.func_71045_bC(), false);
        }
    }

    public boolean isLastHeldItemEqual(ItemStack itemStack, ItemStack itemStack2) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = itemStack2.field_77990_d;
        if (nBTTagCompound == nBTTagCompound2) {
            return true;
        }
        if (nBTTagCompound == null || nBTTagCompound2 == null) {
            return false;
        }
        nBTTagCompound = (NBTTagCompound)nBTTagCompound.func_74737_b();
        nBTTagCompound2 = (NBTTagCompound)nBTTagCompound2.func_74737_b();
        nBTTagCompound.func_82580_o("Energy");
        nBTTagCompound2.func_82580_o("Energy");
        return nBTTagCompound.equals((Object)nBTTagCompound2);
    }
}

