/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.gui.CheckBoxEIO;
import crazypants.enderio.machine.monitor.ContainerPowerMonitor;
import crazypants.enderio.machine.monitor.PacketPowerMonitor;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.GuiContainerBase;
import crazypants.gui.GuiToolTip;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.opengl.GL11;

public class GuiPowerMonitor
extends GuiContainerBase {
    private static final NumberFormat INT_NF = NumberFormat.getIntegerInstance();
    private static final int ICON_SIZE = 16;
    private static final int SPACING = 6;
    private static final int MARGIN = 7;
    private static final int WIDTH = 203;
    private static final int HEIGHT = 146;
    private static final int POWER_X = 185;
    private static final int POWER_Y = 9;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 130;
    protected static final int BOTTOM_POWER_Y = 139;
    private final TilePowerMonitor te;
    private boolean isRedstoneMode = false;
    private CheckBoxEIO enabledB;
    private GuiTextField startTF;
    private GuiTextField endTF;
    private String titleStr;
    private String engineTxt1;
    private String engineTxt2;
    private String engineTxt3;
    private String engineTxt4;
    private String engineTxt5;
    private String engineTxt6;
    private String monHeading1;
    private String monHeading2;
    private String monHeading3;
    private String monHeading4;
    private String monHeading5;

    public GuiPowerMonitor(final TilePowerMonitor te) {
        super(new ContainerPowerMonitor());
        this.te = te;
        this.field_146999_f = 203;
        this.field_147000_g = 146;
        this.titleStr = Lang.localize("gui.powerMonitor.engineControl");
        this.engineTxt1 = Lang.localize("gui.powerMonitor.engineSection1");
        this.engineTxt2 = Lang.localize("gui.powerMonitor.engineSection2");
        this.engineTxt3 = Lang.localize("gui.powerMonitor.engineSection3");
        this.engineTxt4 = Lang.localize("gui.powerMonitor.engineSection4");
        this.engineTxt5 = Lang.localize("gui.powerMonitor.engineSection5");
        this.engineTxt6 = Lang.localize("gui.powerMonitor.engineSection6");
        this.monHeading1 = Lang.localize("gui.powerMonitor.monHeading1");
        this.monHeading2 = Lang.localize("gui.powerMonitor.monHeading2");
        this.monHeading3 = Lang.localize("gui.powerMonitor.monHeading3");
        this.monHeading4 = Lang.localize("gui.powerMonitor.monHeading4");
        this.monHeading5 = Lang.localize("gui.powerMonitor.monHeading5");
        this.addToolTip(new GuiToolTip(new Rectangle(185, 9, 10, 130), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add(PowerDisplayUtil.formatPower(te.getEnergyStored()) + "/" + PowerDisplayUtil.formatPower(te.getMaxEnergyStored()) + " " + PowerDisplayUtil.abrevation());
            }
        });
        int x = 7 + Minecraft.func_71410_x().field_71466_p.func_78256_a(this.titleStr) + 6;
        this.enabledB = new CheckBoxEIO(this, 21267, x, 8);
        this.enabledB.setSelectedToolTip(Lang.localize("gui.enabled"));
        this.enabledB.setUnselectedToolTip(Lang.localize("gui.disabled"));
        this.enabledB.setSelected(te.engineControlEnabled);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int x = this.field_147003_i + 7 + this.getFontRenderer().func_78256_a(this.engineTxt2) + 4;
        int y = this.field_147009_r + 7 + 16 + 16 + this.getFontRenderer().field_78288_b;
        this.startTF = new GuiTextField(this.getFontRenderer(), x, y, 28, 14);
        this.startTF.func_146205_d(true);
        this.startTF.func_146203_f(3);
        this.startTF.func_146195_b(true);
        this.startTF.func_146180_a(INT_NF.format(this.te.asPercentInt(this.te.startLevel)));
        y = y + this.getFontRenderer().field_78288_b + 16 + 16 + 4;
        x = this.field_147003_i + 7 + this.getFontRenderer().func_78256_a(this.engineTxt5);
        this.endTF = new GuiTextField(this.getFontRenderer(), x, y, 28, 14);
        this.endTF.func_146205_d(true);
        this.endTF.func_146203_f(3);
        this.endTF.func_146195_b(false);
        this.endTF.func_146180_a(INT_NF.format(this.te.asPercentInt(this.te.stopLevel)));
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        this.startTF.func_146201_a(par1, par2);
        this.endTF.func_146201_a(par1, par2);
    }

    public void func_73876_c() {
        this.startTF.func_146178_a();
        this.endTF.func_146178_a();
    }

    @Override
    public int getOverlayOffsetX() {
        return 0;
    }

    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        this.startTF.func_146192_a(x, y, par3);
        this.endTF.func_146192_a(x, y, par3);
        y -= this.field_147009_r;
        if ((x -= this.field_147003_i) > 200 && x < 220) {
            if (y > 9 && y < 27) {
                this.isRedstoneMode = false;
                this.enabledB.detach();
            } else if (y > 34 && y < 53) {
                this.isRedstoneMode = true;
                this.enabledB.onGuiInit();
            }
        }
    }

    protected void func_146976_a(float ptick, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/powerMonitor.png");
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.te.getEnergyStoredScaled(130);
        this.func_73729_b(sx + 185, sy + 139 - i1, 245, 0, 10, i1);
        if (this.isRedstoneMode) {
            this.renderRedstoneTab(sx, sy);
        } else {
            this.renderInfoTab(sx, sy);
        }
        this.checkForModifications();
    }

    private void checkForModifications() {
        if (this.enabledB.isSelected() != this.te.engineControlEnabled || this.getInt(this.startTF) != this.te.asPercentInt(this.te.startLevel) || this.getInt(this.endTF) != this.te.asPercentInt(this.te.stopLevel)) {
            this.te.engineControlEnabled = this.enabledB.isSelected();
            int i = this.getInt(this.startTF);
            if (i >= 0) {
                this.te.startLevel = this.te.asPercentFloat(i);
            }
            if ((i = this.getInt(this.endTF)) >= 0) {
                this.te.stopLevel = this.te.asPercentFloat(i);
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPowerMonitor(this.te));
        }
    }

    private int getInt(GuiTextField tf) {
        String txt = tf.func_146179_b();
        if (txt == null) {
            return -1;
        }
        try {
            int val = Integer.parseInt(tf.func_146179_b());
            if (val >= 0 && val <= 100) {
                return val;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void renderRedstoneTab(int sx, int sy) {
        int left;
        this.func_73729_b(sx + 200, sy + 6, 225, 0, 20, 48);
        int x = left = this.field_147003_i + 7;
        int y = this.field_147009_r + 7 + 6;
        int rgb = !this.enabledB.isSelected() ? ColorUtil.getRGB(Color.darkGray) : ColorUtil.getRGB(Color.black);
        FontRenderer fontRenderer = this.getFontRenderer();
        fontRenderer.func_85187_a(this.titleStr, x, y, rgb, false);
        x = left + fontRenderer.func_78256_a(this.titleStr) + 6 + 16 + 6;
        y = this.field_147009_r + 14;
        if (!this.enabledB.isSelected()) {
            rgb = ColorUtil.getRGB(Color.darkGray);
            this.enabledB.func_146112_a(this.field_146297_k, this.field_147003_i, this.field_147009_r);
        } else {
            rgb = ColorUtil.getRGB(Color.black);
        }
        this.enabledB.func_146112_a(this.field_146297_k, this.field_147003_i, this.field_147009_r);
        x = left;
        String txt = this.engineTxt1;
        fontRenderer.func_85187_a(txt, x, y += 22, rgb, false);
        x = left;
        txt = this.engineTxt2;
        fontRenderer.func_85187_a(txt, x, y += 6 + fontRenderer.field_78288_b, rgb, false);
        x = left + fontRenderer.func_78256_a(txt) + 6 + this.startTF.func_146200_o() + 12;
        txt = this.engineTxt3;
        fontRenderer.func_85187_a(txt, x, y, rgb, false);
        x = left;
        txt = this.engineTxt4;
        fontRenderer.func_85187_a(txt, x, y += 16 + fontRenderer.field_78288_b + 6, rgb, false);
        x = left;
        txt = this.engineTxt5;
        fontRenderer.func_85187_a(txt, x, y += 6 + fontRenderer.field_78288_b, rgb, false);
        x += fontRenderer.func_78256_a(txt);
        txt = this.engineTxt3;
        fontRenderer.func_85187_a(txt, x += 7 + this.endTF.func_146200_o() + 10, y, rgb, false);
        this.startTF.func_146194_f();
        this.endTF.func_146194_f();
    }

    private void renderInfoTab(int sx, int sy) {
        this.func_73729_b(sx + 200, sy + 6, 225, 53, 20, 48);
        int headingCol = ColorUtil.getRGB(Color.white);
        int valuesCol = ColorUtil.getRGB(Color.black);
        int x = this.field_147003_i + 7;
        int y = this.field_147009_r + 7;
        int sectionGap = 6;
        FontRenderer fontRenderer = this.getFontRenderer();
        int rgb = headingCol;
        StringBuilder sb = new StringBuilder();
        sb.append(this.monHeading1);
        fontRenderer.func_85187_a(sb.toString(), x, y, rgb, true);
        rgb = valuesCol;
        y += fontRenderer.field_78288_b + 2;
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPower(this.te.powerInConduits));
        sb.append(" ");
        sb.append(PowerDisplayUtil.ofStr());
        sb.append(" ");
        sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInConduits));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
        rgb = headingCol;
        sb = new StringBuilder();
        sb.append(this.monHeading2);
        fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
        rgb = valuesCol;
        y += fontRenderer.field_78288_b + 2;
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPower(this.te.powerInCapBanks));
        sb.append(" ");
        sb.append(PowerDisplayUtil.ofStr());
        sb.append(" ");
        sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInCapBanks));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
        rgb = headingCol;
        sb = new StringBuilder();
        sb.append(this.monHeading3);
        fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
        rgb = valuesCol;
        y += fontRenderer.field_78288_b + 2;
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPower(this.te.powerInMachines));
        sb.append(" ");
        sb.append(PowerDisplayUtil.ofStr());
        sb.append(" ");
        sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInMachines));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
        rgb = headingCol;
        sb = new StringBuilder();
        sb.append(this.monHeading4);
        fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
        rgb = valuesCol;
        y += fontRenderer.field_78288_b + 2;
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPowerFloat(this.te.aveRfSent));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        sb.append(PowerDisplayUtil.perTickStr());
        fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
        rgb = headingCol;
        sb = new StringBuilder();
        sb.append(this.monHeading5);
        fontRenderer.func_85187_a(sb.toString(), x, y += fontRenderer.field_78288_b + sectionGap, rgb, true);
        rgb = valuesCol;
        y += fontRenderer.field_78288_b + 2;
        sb = new StringBuilder();
        sb.append(PowerDisplayUtil.formatPowerFloat(this.te.aveRfReceived));
        sb.append(" ");
        sb.append(PowerDisplayUtil.abrevation());
        sb.append(PowerDisplayUtil.perTickStr());
        fontRenderer.func_85187_a(sb.toString(), x, y, rgb, false);
    }
}

