/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import crazypants.enderio.EnderIOTab;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.light.TileElectricLight;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlockWithMetadata;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockItemElectricLight
extends ItemBlockWithMetadata
implements IResourceTooltipProvider {
    public BlockItemElectricLight(Block block) {
        super(block, block);
        this.func_77637_a(EnderIOTab.tabEnderIO);
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int meta = par1ItemStack.func_77960_j();
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1));
        return Type.values()[meta].unlocName;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Type type : Type.values()) {
            par3List.add(new ItemStack((Item)this, 1, type.ordinal()));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.func_147465_d(x, y, z, this.field_150939_a, 0, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == this.field_150939_a) {
            ForgeDirection onFace = ForgeDirection.values()[side].getOpposite();
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileElectricLight) {
                TileElectricLight el = (TileElectricLight)te;
                el.setFace(onFace);
                Type t = Type.values()[metadata];
                el.setInverted(t.isInverted);
                el.setRequiresPower(t.isPowered);
                el.setWireless(t.isWireless);
            }
        }
        return true;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_77667_c(itemStack);
    }

    public static enum Type {
        ELECTRIC("item.itemElectricLight", false, true, false),
        ELECTRIC_INV("item.itemElectricLightInverted", true, true, false),
        BASIC("item.itemLight", false, false, false),
        BASIC_INV("item.itemLightInverted", true, false, false),
        WIRELESS("item.itemWirelessLight", false, true, true),
        WIRELESS_INV("item.itemWirelessLightInverted", true, true, true);

        final String unlocName;
        final boolean isInverted;
        final boolean isPowered;
        final boolean isWireless;

        private Type(String unlocName, boolean isInverted, boolean isPowered, boolean isWireless) {
            this.unlocName = unlocName;
            this.isInverted = isInverted;
            this.isPowered = isPowered;
            this.isWireless = isWireless;
        }
    }
}

