/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.grid;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.parts.AbstractAEPartBase;

public class AEPartGridBlock
implements IGridBlock {
    protected AbstractAEPartBase part;

    public AEPartGridBlock(AbstractAEPartBase part) {
        this.part = part;
    }

    public EnumSet<ForgeDirection> getConnectableSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public IEnergyGrid getEnergyGrid() {
        IGrid grid = this.getGrid();
        if (grid == null) {
            return null;
        }
        return (IEnergyGrid)grid.getCache(IEnergyGrid.class);
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    public IMEMonitor<IAEFluidStack> getFluidMonitor() {
        IStorageGrid storageGrid = this.getStorageGrid();
        if (storageGrid == null) {
            return null;
        }
        return storageGrid.getFluidInventory();
    }

    public final IGrid getGrid() {
        IGridNode node = this.part.getGridNode();
        if (node != null) {
            return node.getGrid();
        }
        return null;
    }

    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public double getIdlePowerUsage() {
        return this.part.getIdlePowerUsage();
    }

    public IMEMonitor<IAEItemStack> getItemMonitor() {
        IStorageGrid storageGrid = this.getStorageGrid();
        if (storageGrid == null) {
            return null;
        }
        return storageGrid.getItemInventory();
    }

    public DimensionalCoord getLocation() {
        return this.part.getLocation();
    }

    public IGridHost getMachine() {
        return this.part;
    }

    public ItemStack getMachineRepresentation() {
        return this.part.getItemStack(PartItemStack.Network);
    }

    public ISecurityGrid getSecurityGrid() {
        IGrid grid = this.getGrid();
        if (grid == null) {
            return null;
        }
        return (ISecurityGrid)grid.getCache(ISecurityGrid.class);
    }

    public IStorageGrid getStorageGrid() {
        IGrid grid = this.getGrid();
        if (grid == null) {
            return null;
        }
        return (IStorageGrid)grid.getCache(IStorageGrid.class);
    }

    public void gridChanged() {
    }

    public boolean isWorldAccessible() {
        return false;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public final void setNetworkStatus(IGrid grid, int usedChannels) {
    }
}

