/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import mapwriter.forge.MwForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.chunk.Chunk;

public class MwUtil {
    public static final Pattern patternInvalidChars = Pattern.compile("[^a-zA-Z0-9_]");

    public static void logInfo(String s, Object ... args) {
        MwForge.logger.info(String.format(s, args));
    }

    public static void logWarning(String s, Object ... args) {
        MwForge.logger.warn(String.format(s, args));
    }

    public static void logError(String s, Object ... args) {
        MwForge.logger.error(String.format(s, args));
    }

    public static void debug(String s, Object ... args) {
        MwForge.logger.debug(String.format(s, args));
    }

    public static void log(String s, Object ... args) {
        MwUtil.logInfo(String.format(s, args), new Object[0]);
    }

    public static String mungeString(String s) {
        s = s.replace('.', '_');
        s = s.replace('-', '_');
        s = s.replace(' ', '_');
        s = s.replace('/', '_');
        s = s.replace('\\', '_');
        return patternInvalidChars.matcher(s).replaceAll("");
    }

    public static File getFreeFilename(File dir, String baseName, String ext) {
        int i;
        File outputFile = dir != null ? new File(dir, baseName + "." + ext) : new File(baseName + "." + ext);
        for (i = 0; outputFile.exists() && i < 1000; ++i) {
            outputFile = dir != null ? new File(dir, baseName + "." + i + "." + ext) : new File(baseName + "." + i + "." + ext);
        }
        return i < 1000 ? outputFile : null;
    }

    public static void printBoth(String msg) {
        EntityClientPlayerMP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer != null) {
            thePlayer.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
        MwUtil.log("%s", msg);
    }

    public static File getDimensionDir(File worldDir, int dimension) {
        File dimDir = dimension != 0 ? new File(worldDir, "DIM" + dimension) : worldDir;
        return dimDir;
    }

    public static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static int nextHighestPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return v + 1;
    }

    public static String getCurrentDateString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
        return dateFormat.format(new Date());
    }

    public static int distToChunkSq(int x, int z, Chunk chunk) {
        int dx = (chunk.field_76635_g << 4) + 8 - x;
        int dz = (chunk.field_76647_h << 4) + 8 - z;
        return dx * dx + dz * dz;
    }
}

