/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static dyp makeModelCube(String spriteName, int tintIndex) {
        dxb sprite = Config.getMinecraft().L().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static dyp makeModelCube(dxb sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        fb[] facings = fb.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fb facing = facings[i];
            ArrayList<dnz> quads = new ArrayList<dnz>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        dok itemOverrideList = dok.a;
        dyx bakedModel = new dyx(generalQuads, faceQuads, true, true, sprite, dom.a, itemOverrideList);
        return bakedModel;
    }

    public static dyp joinModelsCube(dyp modelBase, dyp modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        fb[] facings = fb.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fb facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.c();
        dxb sprite = modelBase.d();
        dom transforms = modelBase.e();
        dok itemOverrideList = modelBase.f();
        dyx bakedModel = new dyx(generalQuads, faceQuads, ao, builtIn, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static dnz makeBakedQuad(fb facing, dxb sprite, int tintIndex) {
        b posFrom = new b(0.0f, 0.0f, 0.0f);
        b posTo = new b(16.0f, 16.0f, 16.0f);
        dod uv = new dod(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        dob face = new dob(facing, tintIndex, "#" + facing.m(), uv);
        dyq modelRotation = dyq.a;
        doc partRotation = null;
        boolean shade = true;
        doh faceBakery = new doh();
        dnz quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (dyv)modelRotation, partRotation, shade);
        return quad;
    }

    public static dyp makeModel(String modelName, String spriteOldName, String spriteNewName) {
        dxa textureMap = Config.getMinecraft().L();
        dxb spriteOld = textureMap.getSpriteSafe(spriteOldName);
        dxb spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static dyp makeModel(String modelName, dxb spriteOld, dxb spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        dyt modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        dyu mrl = new dyu(modelName, "");
        dyp model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        dyp modelNew = ModelUtils.duplicateModel(model);
        fb[] faces = fb.n;
        for (int i = 0; i < faces.length; ++i) {
            fb face = faces[i];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<dnz> quads, dxb spriteOld, dxb spriteNew) {
        ArrayList<dnz> quadsNew = new ArrayList<dnz>();
        for (dnz quad : quads) {
            if (quad.a() == spriteOld) {
                quad = new dog(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(b pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static csc getOffsetBoundingBox(csc aabb, bmv.b offsetType, ew pos) {
        int x = pos.o();
        int z = pos.q();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == bmv.b.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

