/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Random;

public class TestMath {
    static Random random = new Random();

    public static void main(String[] args) {
        int count = 1000000;
        TestMath.dbg("Test math: " + count);
        for (int i2 = 0; i2 < 1000000; ++i2) {
            TestMath.testMatrix4f_mulTranslate();
            TestMath.testMatrix4f_mulScale();
            TestMath.testMatrix4f_mulQuaternion();
            TestMath.testMatrix3f_mulQuaternion();
            TestMath.testVector4f_transform();
            TestMath.testVector3f_transform();
        }
        TestMath.dbg("Done");
    }

    private static void testMatrix4f_mulTranslate() {
        d m = new d();
        m.setRandom(random);
        d m2 = m.h();
        float x = random.nextFloat();
        float y = random.nextFloat();
        float z = random.nextFloat();
        m.b(d.c((float)x, (float)y, (float)z));
        m2.a(x, y, z);
        if (!m2.equals((Object)m)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m.toString());
            TestMath.dbg(m2.toString());
        }
    }

    private static void testMatrix4f_mulScale() {
        d m = new d();
        m.setRandom(random);
        d m2 = m.h();
        float x = random.nextFloat();
        float y = random.nextFloat();
        float z = random.nextFloat();
        m.b(d.b((float)x, (float)y, (float)z));
        m2.mulScale(x, y, z);
        if (!m2.equals((Object)m)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m.toString());
            TestMath.dbg(m2.toString());
        }
    }

    private static void testMatrix4f_mulQuaternion() {
        d m = new d();
        m.setRandom(random);
        d m2 = m.h();
        g q2 = new g(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m.b(new d(q2));
        m2.a(q2);
        if (!m2.equals((Object)m)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m.toString());
            TestMath.dbg(m2.toString());
        }
    }

    private static void testMatrix3f_mulQuaternion() {
        c m = new c();
        m.setRandom(random);
        c m2 = m.h();
        g q2 = new g(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m.b(new c(q2));
        m2.a(q2);
        if (!m2.equals((Object)m)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m.toString());
            TestMath.dbg(m2.toString());
        }
    }

    private static void testVector3f_transform() {
        k v2 = new k(random.nextFloat(), random.nextFloat(), random.nextFloat());
        k v22 = v2.e();
        c m = new c();
        m.setRandom(random);
        v2.a(m);
        float x = m.getTransformX(v22.a(), v22.b(), v22.c());
        float y = m.getTransformY(v22.a(), v22.b(), v22.c());
        float z = m.getTransformZ(v22.a(), v22.b(), v22.c());
        v22 = new k(x, y, z);
        if (!v22.equals((Object)v2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(v2.toString());
            TestMath.dbg(v22.toString());
        }
    }

    private static void testVector4f_transform() {
        l v2 = new l(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        l v22 = new l(v2.a(), v2.b(), v2.c(), v2.d());
        d m = new d();
        m.setRandom(random);
        v2.a(m);
        float x = m.getTransformX(v22.a(), v22.b(), v22.c(), v22.d());
        float y = m.getTransformY(v22.a(), v22.b(), v22.c(), v22.d());
        float z = m.getTransformZ(v22.a(), v22.b(), v22.c(), v22.d());
        float w = m.getTransformW(v22.a(), v22.b(), v22.c(), v22.d());
        v22 = new l(x, y, z, w);
        if (!v22.equals((Object)v2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(v2.toString());
            TestMath.dbg(v22.toString());
        }
    }

    private static void dbg(String str) {
        System.out.println(str);
    }
}

