/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import net.optifine.Log;
import net.optifine.reflect.IResolvable;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorField;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.reflect.ReflectorResolver;

public class ReflectorClass
implements IResolvable {
    private String targetClassName = null;
    private boolean checked = false;
    private Class targetClass = null;

    public ReflectorClass(String targetClassName) {
        this.targetClassName = targetClassName;
        ReflectorResolver.register(this);
    }

    public ReflectorClass(Class targetClass) {
        this.targetClass = targetClass;
        this.targetClassName = targetClass.getName();
        this.checked = true;
    }

    public Class getTargetClass() {
        if (this.checked) {
            return this.targetClass;
        }
        this.checked = true;
        try {
            this.targetClass = Class.forName(this.targetClassName);
        }
        catch (ClassNotFoundException e2) {
            Log.log("(Reflector) Class not present: " + this.targetClassName);
        }
        catch (Throwable e3) {
            e3.printStackTrace();
        }
        return this.targetClass;
    }

    public boolean exists() {
        return this.getTargetClass() != null;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public boolean isInstance(Object obj) {
        if (this.getTargetClass() == null) {
            return false;
        }
        return this.getTargetClass().isInstance(obj);
    }

    public ReflectorField makeField(String name) {
        return new ReflectorField(this, name);
    }

    public ReflectorMethod makeMethod(String name) {
        return new ReflectorMethod(this, name);
    }

    public ReflectorMethod makeMethod(String name, Class[] paramTypes) {
        return new ReflectorMethod(this, name, paramTypes);
    }

    public ReflectorConstructor makeConstructor(Class[] paramTypes) {
        return new ReflectorConstructor(this, paramTypes);
    }

    @Override
    public void resolve() {
        Class cls2 = this.getTargetClass();
    }
}

