/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.optifine.Config;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class Lang {
    private static final Splitter splitter = Splitter.on((char)'=').limit(2);
    private static final Pattern pattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void resourcesReloaded() {
        HashMap localeProperties = new HashMap();
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "optifine/lang/";
        String EN_US = "en_us";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        if (!Config.getGameSettings().bd.equals(EN_US)) {
            listFiles.add(PREFIX + Config.getGameSettings().bd + SUFFIX);
        }
        String[] files = listFiles.toArray(new String[listFiles.size()]);
        Lang.loadResources((acv)Config.getDefaultResourcePack(), files, localeProperties);
        acv[] resourcePacks = Config.getResourcePacks();
        for (int i2 = 0; i2 < resourcePacks.length; ++i2) {
            acv rp = resourcePacks[i2];
            Lang.loadResources(rp, files, localeProperties);
        }
    }

    private static void loadResources(acv rp, String[] files, Map localeProperties) {
        try {
            for (int i2 = 0; i2 < files.length; ++i2) {
                InputStream in;
                String file = files[i2];
                ww loc = new ww(file);
                if (!rp.b(acw.a, loc) || (in = rp.a(acw.a, loc)) == null) continue;
                Lang.loadLocaleData(in, localeProperties);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void loadLocaleData(InputStream is, Map localeProperties) throws IOException {
        Iterator it = IOUtils.readLines((InputStream)is, (Charset)Charsets.UTF_8).iterator();
        is.close();
        while (it.hasNext()) {
            String[] parts;
            String line = (String)it.next();
            if (line.isEmpty() || line.charAt(0) == '#' || (parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class)) == null || parts.length != 2) continue;
            String key = parts[0];
            String value = pattern.matcher(parts[1]).replaceAll("%$1s");
            localeProperties.put(key, value);
        }
    }

    public static void loadResources(adt resourceManager, String langCode, Map<String, String> map) {
        try {
            String pathLang = "optifine/lang/" + langCode + ".lang";
            ww locLang = new ww(pathLang);
            ads res = resourceManager.a(locLang);
            InputStream is = res.b();
            Lang.loadLocaleData(is, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String get(String key) {
        return eyh.a((String)key, (Object[])new Object[0]);
    }

    public static pg getComponent(String key) {
        return new pg(key);
    }

    public static String get(String key, String def) {
        String str = eyh.a((String)key, (Object[])new Object[0]);
        if (str == null || str.equals(key)) {
            return def;
        }
        return str;
    }

    public static String getOn() {
        return eyh.a((String)"options.on", (Object[])new Object[0]);
    }

    public static String getOff() {
        return eyh.a((String)"options.off", (Object[])new Object[0]);
    }

    public static String getFast() {
        return eyh.a((String)"options.graphics.fast", (Object[])new Object[0]);
    }

    public static String getFancy() {
        return eyh.a((String)"options.graphics.fancy", (Object[])new Object[0]);
    }

    public static String getDefault() {
        return eyh.a((String)"generator.default", (Object[])new Object[0]);
    }
}

