/*
 * Decompiled with CFR 0.152.
 */
public class RandomMobsRule {
    private oa baseResLoc = null;
    private int index;
    private int[] skins = null;
    private oa[] resourceLocations = null;
    private int[] weights = null;
    private arm[] biomes = null;
    private RangeListInt heights = null;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private VillagerProfession[] professions = null;

    public RandomMobsRule(oa baseResLoc, int index, int[] skins, int[] weights, arm[] biomes, RangeListInt heights, NbtTagValue nbtName, VillagerProfession[] professions) {
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.skins = skins;
        this.weights = weights;
        this.biomes = biomes;
        this.heights = heights;
        this.nbtName = nbtName;
        this.professions = professions;
    }

    public boolean isValid(String path) {
        if (this.skins == null || this.skins.length == 0) {
            Config.warn("Invalid skins for rule: " + this.index);
            return false;
        }
        if (this.resourceLocations != null) {
            return true;
        }
        this.resourceLocations = new oa[this.skins.length];
        oa locMcp = RandomMobs.getMcpatcherLocation(this.baseResLoc);
        if (locMcp == null) {
            Config.warn("Invalid path: " + this.baseResLoc.a());
            return false;
        }
        for (int i = 0; i < this.resourceLocations.length; ++i) {
            int index = this.skins[i];
            if (index <= 1) {
                this.resourceLocations[i] = this.baseResLoc;
                continue;
            }
            oa locNew = RandomMobs.getLocationIndexed(locMcp, index);
            if (locNew == null) {
                Config.warn("Invalid path: " + this.baseResLoc.a());
                return false;
            }
            if (!Config.hasResource(locNew)) {
                Config.warn("Texture not found: " + locNew.a());
                return false;
            }
            this.resourceLocations[i] = locNew;
        }
        if (this.weights != null) {
            if (this.weights.length > this.resourceLocations.length) {
                Config.warn("More weights defined than skins, trimming weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, weights2.length);
                this.weights = weights2;
            }
            if (this.weights.length < this.resourceLocations.length) {
                Config.warn("Less weights defined than skins, expanding weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, this.weights.length);
                int avgWeight = MathUtils.getAverage(this.weights);
                for (int i = this.weights.length; i < weights2.length; ++i) {
                    weights2[i] = avgWeight;
                }
                this.weights = weights2;
            }
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i = 0; i < this.weights.length; ++i) {
                if (this.weights[i] < 0) {
                    Config.warn("Invalid weight: " + this.weights[i]);
                    return false;
                }
                this.sumWeights[i] = sum += this.weights[i];
            }
            this.sumAllWeights = sum;
            if (this.sumAllWeights <= 0) {
                Config.warn("Invalid sum of all weights: " + sum);
                this.sumAllWeights = 1;
            }
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            Config.warn("Invalid professions or careers: " + path);
            return false;
        }
        return true;
    }

    public boolean matches(xn el) {
        if (!Matches.biome(el.spawnBiome, this.biomes)) {
            return false;
        }
        if (this.heights != null && el.spawnPosition != null) {
            return this.heights.isInRange(el.spawnPosition.o());
        }
        if (this.nbtName != null) {
            String name;
            String string = name = el.k_() ? el.aL() : null;
            if (!this.nbtName.matchesValue(name)) {
                return false;
            }
        }
        if (this.professions != null && el instanceof agp) {
            agp entityVillager = (agp)el;
            int profInt = entityVillager.cj();
            int careerInt = Reflector.getFieldValueInt(entityVillager, Reflector.EntityVillager_careerId, -1);
            if (profInt < 0 || careerInt < 0) {
                return false;
            }
            boolean matchProfession = false;
            for (int i = 0; i < this.professions.length; ++i) {
                VillagerProfession prof = this.professions[i];
                if (!prof.matches(profInt, careerInt)) continue;
                matchProfession = true;
                break;
            }
            if (!matchProfession) {
                return false;
            }
        }
        return true;
    }

    public oa getTextureLocation(oa loc, int randomId) {
        if (this.resourceLocations == null || this.resourceLocations.length == 0) {
            return loc;
        }
        int index = 0;
        if (this.weights == null) {
            index = randomId % this.resourceLocations.length;
        } else {
            int randWeight = randomId % this.sumAllWeights;
            for (int i = 0; i < this.sumWeights.length; ++i) {
                if (this.sumWeights[i] <= randWeight) continue;
                index = i;
                break;
            }
        }
        return this.resourceLocations[index];
    }
}

